###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_novell_edir_mult_vuln_jul09_lin.nasl 3517 2009-07-24 18:58:24Z jul $
#
# Novell eDirectory Multiple Vulnerabilities - Jul09 (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900901);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"6.4");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-0192", "CVE-2009-2456", "CVE-2009-2457");
  script_bugtraq_id(35666);
  script_name("Novell eDirectory Multiple Vulnerabilities - Jul09 (Linux)");
  desc = "

  Overview: This host is running Novell eDirectory and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  - An unspecified error occurs in DS\NDSD component while processing malformed
    LDAP request containing multiple . (dot) wildcard characters in the Relative
    Distinguished Name (RDN).
  - An unspecified error occurs in DS\NDSD component while processing malformed
    bind LDAP packets.
  - Off-by-one error occurs in the iMonitor component while processing
    malicious HTTP request with a crafted Accept-Language header.

  Impact: Successful exploitation allows attackers to crash the service
  leading to denial of service condition.

  Impact Level: Application

  Affected Software/OS:
  Novell eDirectory 8.8 before SP5 on Linux.

  Fix: Upgrade to  Novell eDirectory 8.8 SP5 or later
  http://www.novell.com/products/edirectory/

  References:
  http://secunia.com/advisories/34160
  http://www.vupen.com/english/advisories/2009/1883
  http://www.novell.com/support/viewContent.do?externalId=3426981

  CVSS Score:
    CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:P/I:N/A:P)
    CVSS Temporal Score : 4.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Novell eDirectory");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_novell_prdts_detect_lin.nasl");
  script_require_keys("Novell/eDir/Lin/Ver");
  exit(0);
}


include("version_func.inc");

edirPort = 8028;
if(!get_port_state(edirPort))
{
  edirPort = 8030;
  if(!get_port_state(edirPort)){
    exit(0);
  }
}

eDirVer =  get_kb_item("Novell/eDir/Lin/Ver");
if(!eDirVer){
  exit(0);
}

if(version_in_range(version:eDirVer, test_version:"8.8",
                                     test_version2:"8.8.SP4")){
  security_warning(edirPort);
}
