/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef COLORCHOOSER_H
#define COLORCHOOSER_H

#include <QFrame>
#include <QColor>
#include <QToolButton>
#include <QLabel>
#include <QWidget>
#include <QWheelEvent>
#include <QGridLayout>

class ColorLabel;
/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class ColorPicker : public QFrame
{
  Q_OBJECT
  private:
    QGridLayout* grid ;
    QColor             m_color;
    QToolButton*       m_button;
    QList<QColor>      m_baseColors;
    QList<QColor>      m_colors;
    QList<ColorLabel*> m_colorLabels;
    int                m_colorsNum;
    int                m_maxColors;

  private:
    void changeRows();

  public:
    ColorPicker(QWidget *parent = 0);
    ~ColorPicker(){};
    void redrawLabels();

    void setButtonColor();

  protected:
    void wheelEvent(QWheelEvent*);

  public slots:
    void selectColorDialog();
    void colorClicked();
    void setColorsNum(int);
    void setColor(QColor color);

  signals:
    void colorChanged(QColor);
};

#endif
