/*
 * Copyright (C) 2008 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "core/css/CSSReflectValue.h"

#include "core/css/CSSIdentifierValue.h"
#include "core/css/CSSPrimitiveValue.h"

namespace blink {

String CSSReflectValue::customCSSText() const {
  if (m_mask)
    return m_direction->cssText() + ' ' + m_offset->cssText() + ' ' +
           m_mask->cssText();
  return m_direction->cssText() + ' ' + m_offset->cssText();
}

bool CSSReflectValue::equals(const CSSReflectValue& other) const {
  return m_direction == other.m_direction &&
         compareCSSValuePtr(m_offset, other.m_offset) &&
         compareCSSValuePtr(m_mask, other.m_mask);
}

DEFINE_TRACE_AFTER_DISPATCH(CSSReflectValue) {
  visitor->trace(m_direction);
  visitor->trace(m_offset);
  visitor->trace(m_mask);
  CSSValue::traceAfterDispatch(visitor);
}

}  // namespace blink
