// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright (C) 2022 StarFive Technology Co., Ltd.
 * Author: Yanhong Wang<yanhong.wang@starfivetech.com>
 */

#include <common.h>
#include <asm/io.h>

static const u32 ddr_train_data[] = {
	0xb00,
	0x101,
	0x640000,
	0x1,
	0x0,
	0x0,
	0x0,
	0x0,
	0x1,
	0x7,
	0x10002,
	0x300080f,
	0x1,
	0x5,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x1010000,
	0x280a0000,
	0x0,
	0x1,
	0x3200000f,
	0x0,
	0x0,
	0x10102,
	0x1,
	0x0,
	0x0,
	0x0,
	0xaa,
	0x55,
	0xb5,
	0x4a,
	0x56,
	0xa9,
	0xa9,
	0xb5,
	0x1000000,
	0x1000000,
	0x0,
	0xf0f0000,
	0x14,
	0x7d0,
	0x300,
	0x0,
	0x0,
	0x1000000,
	0x10101,
	0x0,
	0x30000,
	0x100,
	0x170f,
	0x0,
	0x0,
	0x0,
	0xa140a01,
	0x204010a,
	0x2080510,
	0x40400,
	0x1000101,
	0x10100,
	0x2040f00,
	0x34000000,
	0x0,
	0x0,
	0x1000000,
	0x0,
	0x0,
	0x0,
	0x0,
	0x10100,
	0x80101,
	0x2000200,
	0x1000100,
	0x1000000,
	0x2000200,
	0x200,
	0x0,
	0x0,
	0x0,
	0xe000004,
	0xc0d100f,
	0xa09080b,
	0x2010000,
	0x80103,
	0x200,
	0x0,
	0xf000000,
	0x4,
	0xa,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x30100,
	0x1010001,
	0x10200,
	0x4000103,
	0x1050001,
	0x10600,
	0x107,
	0x0,
	0x0,
	0x10001,
	0x0,
	0x0,
	0x0,
	0x0,
	0x10000,
	0x4,
	0x0,
	0x10000,
	0x0,
	0x3c0003,
	0x80100a0,
	0x16,
	0x2c,
	0x33,
	0x20043,
	0x2000200,
	0x4,
	0x60c,
	0xa1400,
	0x280000,
	0x6,
	0x46,
	0x70,
	0x610,
	0x12b,
	0x4001035,
	0x1010404,
	0x1e01,
	0x1e001e,
	0x1000100,
	0x100,
	0x0,
	0x5060403,
	0x1011108,
	0x1010101,
	0xf0a0a,
	0x0,
	0x0,
	0x4000000,
	0x4021008,
	0x4020206,
	0xc0034,
	0x100038,
	0x17003f,
	0x10001,
	0x10001,
	0x10005,
	0x20064,
	0x100010b,
	0x60006,
	0x650100,
	0x1000065,
	0x10c010c,
	0x1e1a1e1a,
	0x1011e1a,
	0xa070601,
	0xa07060d,
	0x100b080d,
	0xc00f,
	0xc01000,
	0xc01000,
	0x21000,
	0x120005,
	0x190064,
	0x10b,
	0x1100,
	0x1e1a0056,
	0x6000101,
	0x130204,
	0x1e1a0058,
	0x1000101,
	0x230408,
	0x1e1a005e,
	0x9000101,
	0x610,
	0x4040800,
	0x40100,
	0x3000277,
	0xa032001,
	0xa0a,
	0x80908,
	0x901,
	0x1100315c,
	0xa062002,
	0xa0a,
	0x141708,
	0x150d,
	0x2d00838e,
	0xf102004,
	0xf0b,
	0x8c,
	0x578,
	0xc20,
	0x7940,
	0x206a,
	0x14424,
	0x730006,
	0x3030133,
	0x4,
	0x0,
	0x4,
	0x1,
	0x5,
	0x2,
	0x6,
	0x50,
	0x1,
	0x5,
	0x28,
	0x73,
	0xd6,
	0x1,
	0x5,
	0x6b,
	0x1000133,
	0x140040,
	0x10001,
	0x1900040,
	0x1000c,
	0x42b0040,
	0x320,
	0x360014,
	0x1010101,
	0x2020101,
	0x8080404,
	0x67676767,
	0x67676767,
	0x67676767,
	0x67676767,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x5500,
	0x5a00,
	0x55003c,
	0x0,
	0x3c00005a,
	0x5500,
	0x5a00,
	0x55003c,
	0x0,
	0x3c00005a,
	0x18171615,
	0x14131211,
	0x7060504,
	0x3020100,
	0x0,
	0x0,
	0x0,
	0x1000000,
	0x4020201,
	0x80804,
	0x0,
	0x4,
	0x0,
	0x31,
	0x31,
	0x0,
	0x0,
	0x4d4d,
	0x0,
	0x14,
	0x9,
	0x31,
	0x31,
	0x0,
	0x0,
	0x4d4d,
	0x0,
	0x34,
	0x1b,
	0x31,
	0x31,
	0x0,
	0x0,
	0x4d4d,
	0x0,
	0x4,
	0x0,
	0x31,
	0x31,
	0x0,
	0x0,
	0x4d4d,
	0x0,
	0x14,
	0x9,
	0x31,
	0x31,
	0x0,
	0x0,
	0x4d4d,
	0x0,
	0x34,
	0x1b,
	0x31,
	0x31,
	0x0,
	0x0,
	0x4d4d,
	0x0,
	0x4,
	0x0,
	0x31,
	0x31,
	0x0,
	0x0,
	0x4d4d,
	0x0,
	0x14,
	0x9,
	0x31,
	0x31,
	0x0,
	0x0,
	0x4d4d,
	0x0,
	0x34,
	0x1b,
	0x31,
	0x31,
	0x0,
	0x0,
	0x4d4d,
	0x0,
	0x4,
	0x0,
	0x31,
	0x31,
	0x0,
	0x0,
	0x4d4d,
	0x0,
	0x14,
	0x9,
	0x31,
	0x31,
	0x0,
	0x0,
	0x4d4d,
	0x0,
	0x34,
	0x1b,
	0x31,
	0x31,
	0x0,
	0x0,
	0x4d4d,
};

void ddr_phy_train(u32 *phyreg)
{
	u32 i, len;

	len = ARRAY_SIZE(ddr_train_data);
	for (i = 0; i < len; i++)
		out_le32(phyreg + i, ddr_train_data[i]);
}
