/*********************************************************************
 *
 * Written by Nick Gorham
 * (nick@lurcher.org).
 *
 * copyright (c) 1999 Nick Gorham
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 **********************************************************************
 *
 * 2008-12-10   Code adopted by unixODBC-GUI-Qt project. Heavily altered
 * pharvey      to be Qt4 only code.
 * 
 **********************************************************************/

#pragma once

#include "OdbcHandle.h"

class OdbcTest;

class dPrepare : public QDialog 
{
    Q_OBJECT

    public:
		dPrepare( OdbcTest *pOdbcTest, QString name );
        ~dPrepare();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles, *str, *name_len;
		QLabel *l_handle, *l_str, *l_name_len;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Ok();
};

class dExecute : public QDialog 
{
    Q_OBJECT

    public:
		dExecute( OdbcTest *pOdbcTest, QString name );
        ~dExecute();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles;
		QLabel *l_handle;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Ok();
};

class dExecDirect : public QDialog 
{
    Q_OBJECT

    public:
		dExecDirect( OdbcTest *pOdbcTest, QString name );
        ~dExecDirect();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles, *str, *name_len;
		QLabel *l_handle, *l_str, *l_name_len;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Ok();
};

class dNumParams : public QDialog 
{
    Q_OBJECT

    public:
        dNumParams( OdbcTest *pOdbcTest, QString name );
        ~dNumParams();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles;
		QCheckBox *valid;
		QLabel *l_handle;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Valid();
		void Ok();
};

class dCancel : public QDialog 
{
    Q_OBJECT

    public:
		dCancel( OdbcTest *pOdbcTest, QString name );
        ~dCancel();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles;
		QLabel *l_handle;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Ok();
};

class dCloseCursor : public QDialog 
{
    Q_OBJECT

    public:
		dCloseCursor( OdbcTest *pOdbcTest, QString name );
        ~dCloseCursor();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles;
		QLabel *l_handle;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Ok();
};

class dGetCursorName : public QDialog 
{
    Q_OBJECT

    public:
		dGetCursorName( OdbcTest *pOdbcTest, QString name );
        ~dGetCursorName();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles, *option;
		QLabel *l_handle, *l_option, *l_buffer_len;
		QCheckBox *name_valid, *cursor_valid;
		QLineEdit *buffer_len;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Ok();
		void CursorValid();
		void NameValid();
};

class dFreeStmt : public QDialog 
{
    Q_OBJECT

    public:
		dFreeStmt( OdbcTest *pOdbcTest, QString name );
        ~dFreeStmt();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles, *option;
		QLabel *l_handle, *l_option;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Ok();
};

class dSetCursorName : public QDialog 
{
    Q_OBJECT

    public:
		dSetCursorName( OdbcTest *pOdbcTest, QString name );
        ~dSetCursorName();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles, *str, *name_len;
		QLabel *l_handle, *l_str, *l_name_len;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Ok();
};

class dDescribeParam : public QDialog 
{
    Q_OBJECT

    public:
        dDescribeParam( OdbcTest *pOdbcTest, QString name );
        ~dDescribeParam();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles;
		QLineEdit *param_num;
		QLabel *l_handle, *l_param_num;
		QCheckBox *type_valid;
		QCheckBox *digit_valid;
		QCheckBox *size_valid;
		QCheckBox *null_valid;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;
		const char *data_type_to_str( int );

	protected slots:
		void type_clkd();
		void digit_clkd();
		void size_clkd();
		void null_clkd();
		void Ok();
};

class dParamData : public QDialog 
{
    Q_OBJECT

    public:
        dParamData( OdbcTest *pOdbcTest, QString name );
        ~dParamData();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles;
		QLabel *l_handle;
		QCheckBox *value_valid;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void value_clkd();
		void Ok();
};

class dParamOption : public QDialog 
{
    Q_OBJECT

    public:
        dParamOption( OdbcTest *pOdbcTest, QString name );
        ~dParamOption();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles;
		QLabel *l_handle;
		QLineEdit *crow_num;
		QLabel *l_param_num, *l_crow_num;
		QCheckBox *pirow_valid;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void pirow_clkd();
		void Ok();
};

class dPutData : public QDialog 
{
    Q_OBJECT

    public:
		dPutData( OdbcTest *pOdbcTest, QString name );
        ~dPutData();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles, *data_ptr, *str_len;
		QLabel *l_handle, *l_data_ptr, *l_str_len;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Ok();
};

class dBindParameter : public QDialog 
{
    Q_OBJECT

    public:
		dBindParameter( OdbcTest *pOdbcTest, QString name );
        ~dBindParameter();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles, *io_type, *value_type;
		QComboBox *param_type, *param_value, *strlen_or_ind;
		QLabel *l_handle, *l_io_type, *l_value_type;
        QLabel *l_param_type, *l_param_value, *l_strlen_or_ind, *l_param_num;
        QLineEdit *column_size, *decimal_digits, *buffer_length, *param_num;
        QLabel *l_column_size, *l_decimal_digits, *l_buffer_length;
		QCheckBox *len_data_at_exec;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Ok();
};

class dBindParam : public QDialog 
{
    Q_OBJECT

    public:
		dBindParam( OdbcTest *pOdbcTest, QString name );
        ~dBindParam();

	protected:
		QPushButton *ok, *cancel, *help;
		QComboBox *handles, *value_type;
		QComboBox *param_type, *param_value, *strlen_or_ind;
		QLabel *l_handle, *l_value_type;
        QLabel *l_param_type, *l_param_value, *l_strlen_or_ind, *l_param_num;
        QLineEdit *column_size, *decimal_digits, *param_num;
        QLabel *l_column_size, *l_decimal_digits;
		QCheckBox *len_data_at_exec;
		QTextEdit *in_win;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Ok();
};

class dAllocStmt : public QDialog 
{
    Q_OBJECT

    public:
        dAllocStmt( OdbcTest *pOdbcTest, QString name );
        ~dAllocStmt();

	protected:
		QPushButton *ok, *cancel, *help;
		QTextEdit *in_win;
		QCheckBox *handle_valid;
        QComboBox *handles;
        QLabel *l_handles;
		QTextEdit *out_win;
		OdbcTest *pOdbcTest;
		QString txt;

	protected slots:
		void Ok();
        void handle_clkd();
};


