package ONVIF::Media::Types::StreamingCapabilities;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/media/wsdl' };

our $XML_ATTRIBUTE_CLASS = 'ONVIF::Media::Types::StreamingCapabilities::_StreamingCapabilities::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables


__PACKAGE__->_factory(
    [ qw(
    ) ],
    {
    },
    {
    },
    {

    }
);

} # end BLOCK




package ONVIF::Media::Types::StreamingCapabilities::_StreamingCapabilities::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %RTPMulticast_of :ATTR(:get<RTPMulticast>);
my %RTP_TCP_of :ATTR(:get<RTP_TCP>);
my %RTP_RTSP_TCP_of :ATTR(:get<RTP_RTSP_TCP>);
my %NonAggregateControl_of :ATTR(:get<NonAggregateControl>);
my %NoRTSPStreaming_of :ATTR(:get<NoRTSPStreaming>);

__PACKAGE__->_factory(
    [ qw(
        RTPMulticast
        RTP_TCP
        RTP_RTSP_TCP
        NonAggregateControl
        NoRTSPStreaming
    ) ],
    {

        RTPMulticast => \%RTPMulticast_of,

        RTP_TCP => \%RTP_TCP_of,

        RTP_RTSP_TCP => \%RTP_RTSP_TCP_of,

        NonAggregateControl => \%NonAggregateControl_of,

        NoRTSPStreaming => \%NoRTSPStreaming_of,
    },
    {
        RTPMulticast => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        RTP_TCP => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        RTP_RTSP_TCP => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        NonAggregateControl => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        NoRTSPStreaming => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    }
);

} # end BLOCK




1;


=pod

=head1 NAME

ONVIF::Media::Types::StreamingCapabilities

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
StreamingCapabilities from the namespace http://www.onvif.org/ver10/media/wsdl.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over



=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::StreamingCapabilities
 },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ONVIF::Media::Types::StreamingCapabilities::_StreamingCapabilities::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * RTPMulticast

 Indicates support for RTP multicast.



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::boolean|SOAP::WSDL::XSD::Typelib::Builtin::boolean>.

=item * RTP_TCP

 Indicates support for RTP over TCP.



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::boolean|SOAP::WSDL::XSD::Typelib::Builtin::boolean>.

=item * RTP_RTSP_TCP

 Indicates support for RTP/RTSP/TCP.



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::boolean|SOAP::WSDL::XSD::Typelib::Builtin::boolean>.

=item * NonAggregateControl

 Indicates support for non aggregate RTSP control.



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::boolean|SOAP::WSDL::XSD::Typelib::Builtin::boolean>.

=item * NoRTSPStreaming

  Indicates the device does not support live media streaming via RTSP.



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::boolean|SOAP::WSDL::XSD::Typelib::Builtin::boolean>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

