#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for junos_routing_options
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type

DOCUMENTATION = """
---
module: junos_routing_options
version_added: 2.8.0
short_description: Manage routing-options configuration on Junos devices.
description: This module manages routing-options configuration on devices running Junos.
author: Rohit Thakur (@rohitthakur2590)
requirements:
  - ncclient (>=v0.6.4)
  - xmltodict (>=0.12.0)
notes:
  - This module requires the netconf system service be enabled on the device being managed.
  - This module works with connection C(netconf).
  - See L(the Junos OS Platform Options,https://docs.ansible.com/ansible/latest/network/user_guide/platform_junos.html).
  - Tested against JunOS v18.4R1
options:
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the Junos device
      by executing the command B(show system routing-options).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  config:
    description: A dictionary of routing-options configuration.
    type: dict
    suboptions:
      autonomous_system:
        description: Specify Autonomous system number.
        type: dict
        suboptions:
          as_number:
            description: Specify Autonomous system number.
            type: str
            required: true
          loops:
            description: Specify maximum number of times this AS can be in an AS path.
            type: int
          asdot_notation:
            description: Enable AS-Dot notation to display true 4 byte AS numbers.
            type: bool
      router_id:
        description: Specify Router identifier.
        type: str
  state:
    description:
    - The state the configuration should be left in.
    - Refer to examples for more details.
    type: str
    choices:
    - merged
    - replaced
    - deleted
    - overridden
    - parsed
    - gathered
    - rendered
    default: merged
"""
EXAMPLES = """
# Using merged
#
# Before state
# ------------
#
# vagrant@vsrx# show system routing-options
#
- name: Merge provided NTP configuration into running configuration.
  junipernetworks.junos.junos_routing_options:
    config:
      autonomous_system:
        as_number: 2
        asdot_notation: true
    state: merged
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {
#         "autonomous_system": {
#             "as_number": "2",
#             "asdot_notation": true
#         }
#     },
#     "before": {},
#     "changed": true,
#     "commands": [
#           "<nc:routing-options xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#           "<nc:autonomous-system>2<nc:asdot-notation/></nc:autonomous-system></nc:routing-options>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show routing-options
# autonomous-system 2 asdot-notation;
#
#
# Using Replaced
# Before state
# ------------
#
# vagrant@vsrx# show routing-options
# autonomous-system 2 asdot-notation;

- name: Replaced running routing-options configuration with provided configuration
  junipernetworks.junos.junos_routing_options:
    config:
      autonomous_system:
        as_number: 2
        asdot_notation: true
      router_id: "1.1.1.1"
    state: replaced
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {
#         "autonomous_system": {
#             "as_number": "2",
#             "asdot_notation": true
#         },
#         "router_id": "1.1.1.1"
#     },
#     "before": {
#         "autonomous_system": {
#             "as_number": "2",
#             "asdot_notation": true
#         }
#     },
#     "changed": true,
#     "commands": [
#             "<nc:routing-options xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#             "<nc:autonomous-system delete=\"delete\"/><nc:autonomous-system>2<nc:asdot-notation/>"
#             "</nc:autonomous-system><nc:router-id>1.1.1.1</nc:router-id></nc:routing-options>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show routing-options
# router-id 1.1.1.1;
# autonomous-system 2 asdot-notation;


# Using overridden
#
# vagrant@vsrx# show routing-options
# autonomous-system 2 asdot-notation;

- name: Override running routing-options configuration with provided configuration
  junipernetworks.junos.junos_routing_options:
    config:
      autonomous_system:
        as_number: 2
        asdot_notation: true
      router_id: "1.1.1.1"
    state: overridden
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {
#         "autonomous_system": {
#             "as_number": "2",
#             "asdot_notation": true
#         },
#         "router_id": "1.1.1.1"
#     },
#     "before": {
#         "autonomous_system": {
#             "as_number": "2",
#             "asdot_notation": true
#         }
#     },
#     "changed": true,
#     "commands": [
#             "<nc:routing-options xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#             "<nc:autonomous-system delete=\"delete\"/><nc:autonomous-system>2<nc:asdot-notation/>"
#             "</nc:autonomous-system><nc:router-id>1.1.1.1</nc:router-id></nc:routing-options>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show routing-options
# router-id 1.1.1.1;
# autonomous-system 2 asdot-notation;
#
# Using deleted
#
# Before state
# ------------
#
# vagrant@vsrx# show routing-options
# router-id 1.1.1.1;
# autonomous-system 2 asdot-notation;
#
- name: Delete running routing-options configuration
  junipernetworks.junos.junos_routing_options:
    config:
    state: deleted
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {},
#     "before": {
#         "autonomous_system": {
#             "as_number": "2",
#             "asdot_notation": true
#         },
#         "router_id": "1.1.1.1"
#     },
#     "changed": true,
#     "commands": [
#               "<nc:routing-options xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#               "<nc:autonomous-system delete=\"delete\"/><nc:router-id delete=\"delete\"/></nc:routing-options>"
#     ]
# After state
# -----------
#
# vagrant@vsrx# show routing-options
#
# [edit]
# Using gathered
#
# Before state
# ------------
#
# vagrant@vsrx# show routing-options
# router-id 1.1.1.1;
# autonomous-system 2 asdot-notation;

- name: Gather running routing-options configuration
  junipernetworks.junos.junos_routing_options:
    state: gathered
#
# -------------------------
# Module Execution Result
# -------------------------
#     "gathered": {
#         "autonomous_system": {
#             "as_number": "2",
#             "asdot_notation": true
#         },
#         "router_id": "1.1.1.1"
#     },
#     "changed": false,
# Using rendered
#
# Before state
# ------------
#
- name: Render xml for provided facts.
  junipernetworks.junos.junos_routing_options:
    config:
      autonomous_system:
        as_number: 2
        asdot_notation: true
        loops: 4
      router_id: 12.12.12.12
    state: rendered
#
# -------------------------
# Module Execution Result
# -------------------------
#     "rendered": [
#           "<nc:routing-options xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">
#           "<nc:autonomous-system>2<nc:loops>4</nc:loops><nc:asdot-notation/></nc:autonomous-system>
#           "<nc:router-id>12.12.12.12</nc:router-id></nc:routing-options>"
#     ]
#
# Using parsed
# parsed.cfg
# ------------
# <?xml version="1.0" encoding="UTF-8"?>
# <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
#     <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
#         <version>18.4R1-S2.4</version>
#         <routing-options>
#             <router-id>12.12.12.12</router-id>
#             <autonomous-system>
#                 <as-number>2</as-number>
#                 <loops>4</loops>
#                 <asdot-notation/>
#             </autonomous-system>
#         </routing-options>
#     </configuration>
# </rpc-reply>
#
- name: Parse routing-options running config
  junipernetworks.junos.junos_routing_options:
    running_config: "{{ lookup('file', './parsed.cfg') }}"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "parsed":  {
#         "autonomous_system": {
#             "as_number": "2",
#             "asdot_notation": true,
#             "loops": 4
#         },
#         "router_id": "12.12.12.12"
#     }
#
"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: dict
after:
  description: The resulting configuration model invocation.
  returned: when changed
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: dict
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['<nc:autonomous-system delete=\"delete\"/><nc:router-id delete=\"delete\"/></nc:routing-options>']
"""


from ansible.module_utils.basic import AnsibleModule

from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.argspec.routing_options.routing_options import (
    Routing_optionsArgs,
)
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.routing_options.routing_options import (
    Routing_options,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    module = AnsibleModule(
        argument_spec=Routing_optionsArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
    )

    result = Routing_options(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
