-- $Id: longexp.vhdl 4836 2009-11-18 16:35:40Z potyra $ 

-- Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.

library ieee;
use ieee.std_logic_1164.all;
ENTITY tb is 
END ENTITY tb;

ARCHITECTURE impl of tb is
	signal bus_addr : std_logic_vector(31 downto 0);
	signal is_own_addr : std_logic;
	signal is_addr_phase : std_logic;
	signal conf_addr : std_logic_vector(31 downto 4);
BEGIN
	decode_own_address : process(is_addr_phase)
	begin
		if	is_addr_phase = '1'
		    and bus_addr(31) = conf_addr(31)
		    and bus_addr(30) = conf_addr(30)
		    and bus_addr(29) = conf_addr(29)
		    and bus_addr(28) = conf_addr(28)
		    and bus_addr(27) = conf_addr(27)
		    and bus_addr(26) = conf_addr(26)
		    and bus_addr(25) = conf_addr(25)
		    and bus_addr(24) = conf_addr(24)
		    and bus_addr(23) = conf_addr(23)
		    and bus_addr(22) = conf_addr(22)
		    and bus_addr(21) = conf_addr(21)
		    and bus_addr(20) = conf_addr(20)
		    and bus_addr(19) = conf_addr(19)
		    and bus_addr(18) = conf_addr(18)
		    and bus_addr(17) = conf_addr(17)
		    and bus_addr(16) = conf_addr(16)
		    and bus_addr(15) = conf_addr(15)
		    and bus_addr(14) = conf_addr(14)
		    and bus_addr(13) = conf_addr(13)
		    and bus_addr(12) = conf_addr(12)
		    and bus_addr(11) = conf_addr(11)
		    and bus_addr(10) = conf_addr(10)
		    and bus_addr(9) = conf_addr(9)
		    and bus_addr(8) = conf_addr(8)
		    and bus_addr(7) = conf_addr(7)
		    and bus_addr(6) = conf_addr(6)
		    and bus_addr(5) = conf_addr(5)
		    and bus_addr(4) = conf_addr(4)
		then
			is_own_addr <= '1';
		else
			is_own_addr <= '0';
		end if;
	end process;
END ARCHITECTURE impl;
