import { BinaryView, Frag } from "@ot-builder/bin-util";
import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Gsub } from "@ot-builder/ot-layout";
import { LookupReader, LookupWriter, SubtableReadingContext, SubtableWriteContext } from "../gsub-gpos-shared/general";
export declare class GsubLigatureReader implements LookupReader<Gsub.Lookup, Gsub.Ligature> {
    createLookup(): import("@ot-builder/prelude").CaseType<typeof Gsub.LookupType.Ligature, Gsub.LigatureProp>;
    parseSubtable(view: BinaryView, lookup: Gsub.Ligature, context: SubtableReadingContext<Gsub.Lookup>): void;
}
type LigatureCont = [OtGlyph[], OtGlyph];
declare class State {
    mapping: Map<OtGlyph, LigatureCont[]>;
    size: number;
    tryAddMapping(firstComponent: OtGlyph, [restComponents, to]: LigatureCont): boolean;
}
export declare class GsubLigatureWriter implements LookupWriter<Gsub.Lookup, Gsub.Ligature> {
    canBeUsed(l: Gsub.Lookup): l is Gsub.Ligature;
    getLookupType(): number;
    getLookupTypeSymbol(): symbol;
    flush(frags: Frag[], state: State, ctx: SubtableWriteContext<Gsub.Lookup>): void;
    createSubtableFragments(lookup: Gsub.Ligature, ctx: SubtableWriteContext<Gsub.Lookup>): Frag[];
}
export {};
//# sourceMappingURL=gsub-ligature.d.ts.map