# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.chaos.aio import ChaosManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestChaosManagementExperimentsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ChaosManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_experiments_list_all(self, resource_group):
        response = self.client.experiments.list_all(
            api_version="2025-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_experiments_list(self, resource_group):
        response = self.client.experiments.list(
            resource_group_name=resource_group.name,
            api_version="2025-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_experiments_get(self, resource_group):
        response = await self.client.experiments.get(
            resource_group_name=resource_group.name,
            experiment_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_experiments_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.experiments.begin_create_or_update(
                resource_group_name=resource_group.name,
                experiment_name="str",
                resource={
                    "location": "str",
                    "selectors": ["chaos_target_selector"],
                    "steps": [{"branches": [{"actions": ["chaos_experiment_action"], "name": "str"}], "name": "str"}],
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "name": "str",
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_experiments_begin_update(self, resource_group):
        response = await (
            await self.client.experiments.begin_update(
                resource_group_name=resource_group.name,
                experiment_name="str",
                properties={
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "tags": {"str": "str"},
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_experiments_begin_delete(self, resource_group):
        response = await (
            await self.client.experiments.begin_delete(
                resource_group_name=resource_group.name,
                experiment_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_experiments_begin_cancel(self, resource_group):
        response = await (
            await self.client.experiments.begin_cancel(
                resource_group_name=resource_group.name,
                experiment_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_experiments_list_all_executions(self, resource_group):
        response = self.client.experiments.list_all_executions(
            resource_group_name=resource_group.name,
            experiment_name="str",
            api_version="2025-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_experiments_get_execution(self, resource_group):
        response = await self.client.experiments.get_execution(
            resource_group_name=resource_group.name,
            experiment_name="str",
            execution_id="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_experiments_execution_details(self, resource_group):
        response = await self.client.experiments.execution_details(
            resource_group_name=resource_group.name,
            experiment_name="str",
            execution_id="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_experiments_begin_start(self, resource_group):
        response = await (
            await self.client.experiments.begin_start(
                resource_group_name=resource_group.name,
                experiment_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
