#include <gtest/gtest.h>

#include "litehtml.h"

using namespace litehtml;

TEST(MediaQueryTest, Check) {
  media_query_expression e;
  media_features k;

  e = media_query_expression(), e.feature = media_feature_width, e.val = 100;
  k = media_features(), k.width = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.width = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.width = 500;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_min_width, e.val = 100;
  k = media_features(), k.width = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.width = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.width = 500;
  EXPECT_TRUE(e.check(k));
  e = media_query_expression(), e.feature = media_feature_max_width, e.val = 100;
  k = media_features(), k.width = 0;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.width = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.width = 500;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_height, e.val = 100;
  k = media_features(), k.height = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.height = 500;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_min_height, e.val = 100;
  k = media_features(), k.height = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.height = 500;
  EXPECT_TRUE(e.check(k));
  e = media_query_expression(), e.feature = media_feature_max_height, e.val = 100;
  k = media_features(), k.height = 0;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.height = 500;
  EXPECT_TRUE(!e.check(k));

  e = media_query_expression(), e.feature = media_feature_device_width, e.val = 100;
  k = media_features(), k.device_width = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.device_width = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.device_width = 500;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_min_device_width, e.val = 100;
  k = media_features(), k.device_width = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.device_width = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.device_width = 500;
  EXPECT_TRUE(e.check(k));
  e = media_query_expression(), e.feature = media_feature_max_device_width, e.val = 100;
  k = media_features(), k.device_width = 0;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.device_width = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.device_width = 500;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_device_height, e.val = 100;
  k = media_features(), k.device_height = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.device_height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.device_height = 500;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_min_device_height, e.val = 100;
  k = media_features(), k.device_height = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.device_height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.device_height = 500;
  EXPECT_TRUE(e.check(k));
  e = media_query_expression(), e.feature = media_feature_max_device_height, e.val = 100;
  k = media_features(), k.device_height = 0;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.device_height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.device_height = 500;
  EXPECT_TRUE(!e.check(k));

  e = media_query_expression(), e.feature = media_feature_orientation, e.val = (int)media_orientation_portrait;
  k = media_features(), k.width = 0, k.height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.width = 100, k.height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.width = 500, k.height = 100;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_orientation, e.val = (int)media_orientation_landscape;
  k = media_features(), k.width = 0, k.height = 100;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.width = 100, k.height = 100;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.width = 500, k.height = 100;
  EXPECT_TRUE(e.check(k));
  e = media_query_expression(), e.feature = media_feature_aspect_ratio, e.val = 100, e.val2 = 100;
  k = media_features(), k.width = 0, k.height = 100;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.width = 100, k.height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.width = 500, k.height = 100;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_min_aspect_ratio, e.val = 100, e.val2 = 100;
  k = media_features(), k.width = 0, k.height = 100;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.width = 100, k.height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.width = 500, k.height = 100;
  EXPECT_TRUE(e.check(k));
  e = media_query_expression(), e.feature = media_feature_max_aspect_ratio, e.val = 100, e.val2 = 100;
  k = media_features(), k.width = 0, k.height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.width = 100, k.height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.width = 500, k.height = 100;
  EXPECT_TRUE(!e.check(k));

  e = media_query_expression(), e.feature = media_feature_device_aspect_ratio, e.val = 100, e.val2 = 100;
  k = media_features(), k.device_width = 0, k.device_height = 100;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.device_width = 100, k.device_height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.device_width = 500, k.device_height = 100;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_min_device_aspect_ratio, e.val = 100, e.val2 = 100;
  k = media_features(), k.device_width = 0, k.device_height = 100;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.device_width = 100, k.device_height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.device_width = 500, k.device_height = 100;
  EXPECT_TRUE(e.check(k));
  e = media_query_expression(), e.feature = media_feature_max_device_aspect_ratio, e.val = 100, e.val2 = 100;
  k = media_features(), k.device_width = 0, k.device_height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.device_width = 100, k.device_height = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.device_width = 500, k.device_height = 100;
  EXPECT_TRUE(!e.check(k));

  e = media_query_expression(), e.feature = media_feature_color, e.val = 100;
  k = media_features(), k.color = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.color = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.color = 500;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_min_color, e.val = 100;
  k = media_features(), k.color = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.color = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.color = 500;
  EXPECT_TRUE(e.check(k));
  e = media_query_expression(), e.feature = media_feature_max_color, e.val = 100;
  k = media_features(), k.color = 0;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.color = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.color = 500;
  EXPECT_TRUE(!e.check(k));

  e = media_query_expression(), e.feature = media_feature_color_index, e.val = 100;
  k = media_features(), k.color_index = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.color_index = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.color_index = 500;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_min_color_index, e.val = 100;
  k = media_features(), k.color_index = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.color_index = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.color_index = 500;
  EXPECT_TRUE(e.check(k));
  e = media_query_expression(), e.feature = media_feature_max_color_index, e.val = 100;
  k = media_features(), k.color_index = 0;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.color_index = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.color_index = 500;
  EXPECT_TRUE(!e.check(k));

  e = media_query_expression(), e.feature = media_feature_monochrome, e.val = 100;
  k = media_features(), k.monochrome = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.monochrome = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.monochrome = 500;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_min_monochrome, e.val = 100;
  k = media_features(), k.monochrome = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.monochrome = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.monochrome = 500;
  EXPECT_TRUE(e.check(k));
  e = media_query_expression(), e.feature = media_feature_max_monochrome, e.val = 100;
  k = media_features(), k.monochrome = 0;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.monochrome = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.monochrome = 500;
  EXPECT_TRUE(!e.check(k));

  e = media_query_expression(), e.feature = media_feature_resolution, e.val = 100;
  k = media_features(), k.resolution = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.resolution = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.resolution = 500;
  EXPECT_TRUE(!e.check(k));
  e = media_query_expression(), e.feature = media_feature_min_resolution, e.val = 100;
  k = media_features(), k.resolution = 0;
  EXPECT_TRUE(!e.check(k));
  k = media_features(), k.resolution = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.resolution = 500;
  EXPECT_TRUE(e.check(k));
  e = media_query_expression(), e.feature = media_feature_max_resolution, e.val = 100;
  k = media_features(), k.resolution = 0;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.resolution = 100;
  EXPECT_TRUE(e.check(k));
  k = media_features(), k.resolution = 500;
  EXPECT_TRUE(!e.check(k));
}
