% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graph_from_graph_series.R
\name{get_graph_from_graph_series}
\alias{get_graph_from_graph_series}
\title{Get a graph available in a series}
\usage{
get_graph_from_graph_series(graph_series, graph_no)
}
\arguments{
\item{graph_series}{A graph series object of type \code{dgr_graph_1D}.}

\item{graph_no}{The index of the graph in the graph series.}
}
\description{
Using a graph series object of type \code{dgr_graph_1D}, get a graph object.
}
\examples{
# Create three graphs
graph_1 <-
  create_graph() \%>\%
  add_path(n = 4)

graph_2 <-
  create_graph() \%>\%
  add_cycle(n = 5)

graph_3 <-
  create_graph() \%>\%
  add_star(n = 6)

# Create an empty graph series
# and add the graphs
series <-
  create_graph_series() \%>\%
  add_graph_to_graph_series(
    graph = graph_1) \%>\%
  add_graph_to_graph_series(
    graph = graph_2) \%>\%
  add_graph_to_graph_series(
    graph = graph_3)

# Get the second graph in the series
extracted_graph <-
  series \%>\%
  get_graph_from_graph_series(
    graph_no = 2)

}
