% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtlFinder.R
\name{qtlFinder}
\alias{qtlFinder}
\title{Distance-based signal identification}
\usage{
qtlFinder(
  d,
  Chromosome = "Chromosome",
  Position = "Position",
  MarkerName = "MarkerName",
  Allele1 = "Allele1",
  Allele2 = "Allele2",
  EAF = "Freq1",
  Effect = "Effect",
  StdErr = "StdErr",
  log10P = "log10P",
  N = "N",
  radius = 1e+06,
  collapse.hla = TRUE,
  build = "hg19"
)
}
\arguments{
\item{d}{input data.}

\item{Chromosome}{chromosome.}

\item{Position}{position.}

\item{MarkerName}{RSid or SNPid.}

\item{Allele1}{effect allele.}

\item{Allele2}{other allele.}

\item{EAF}{effect allele frequency.}

\item{Effect}{b.}

\item{StdErr}{SE.}

\item{log10P}{-log(P).}

\item{N}{sample size.}

\item{radius}{a flanking distance.}

\item{collapse.hla}{a flag to collapse signals in the HLA region.}

\item{build}{genome build to define the HLA region.}
}
\value{
The function lists QTLs and meta-information.
}
\description{
Distance-based signal identification
}
\details{
This function implements an iterative merging algorithm to identify signals.
The setup follows output from METAL. When collapse.hla=TRUE, a single most
significant signal in the HLA region is chosen. The Immunogenomics paper gives
hg19/GRCh37: chr6:28477797-33448354 (6p22.1-21.3),
hg38/GRCh38: chr6:28510020-33480577.
}
\examples{
\dontrun{
  f <- "ZPI_dr.p.gz"
  varlist=c("Chromosome","Position","MarkerName","Allele1","Allele2",
            "Freq1","FreqSE","MinFreq","MaxFreq",
            "Effect","StdErr","log10P","Direction",
            "HetISq","HetChiSq","HetDf","logHetP","N")
  d <- read.table(f,col.names=varlist,check.names=FALSE)
  qtlFinder(d)
}
}
