% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous-tw3.R
\name{pal_tw3}
\alias{pal_tw3}
\title{Tailwind CSS color palettes}
\usage{
pal_tw3(
  palette = c("slate", "gray", "zinc", "neutral", "stone", "red", "orange", "amber",
    "yellow", "lime", "green", "emerald", "teal", "cyan", "sky", "blue", "indigo",
    "violet", "purple", "fuchsia", "pink", "rose"),
  n = 10,
  alpha = 1,
  reverse = FALSE
)
}
\arguments{
\item{palette}{Palette type. There are 22 available options:
\itemize{
\item \code{"slate"}
\item \code{"gray"}
\item \code{"zinc"}
\item \code{"neutral"}
\item \code{"stone"}
\item \code{"red"}
\item \code{"orange"}
\item \code{"amber"}
\item \code{"yellow"}
\item \code{"lime"}
\item \code{"green"}
\item \code{"emerald"}
\item \code{"teal"}
\item \code{"cyan"}
\item \code{"sky"}
\item \code{"blue"}
\item \code{"indigo"}
\item \code{"violet"}
\item \code{"purple"}
\item \code{"fuchsia"}
\item \code{"pink"}
\item \code{"rose"}
}}

\item{n}{Number of individual colors to be generated.}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}

\item{reverse}{Logical. Should the order of the colors be reversed?}
}
\description{
Tailwind CSS color palettes.
}
\examples{
library("scales")
show_col(pal_tw3("rose")(10))
show_col(pal_tw3("rose", n = 30, alpha = 0.6, reverse = TRUE)(30))
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
