% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{n2NA}
\alias{n2NA}
\title{Convert nothing to R missing(NA).}
\usage{
n2NA(x, nothings = c("\\\\.", "\\\\s"), zapspace = TRUE)
}
\arguments{
\item{x}{A character vector. If x is not a character vector, it is
returned unaltered without warning.}

\item{nothings}{A vector of values to be matched by regular
expressions as missing.  The default vector is c("\\.",
"\\s"), where "\\." means a literal period (backslashes needed
to escape the symbol which would otherwise match anything in a
regular expression).}

\item{zapspace}{Should leading and trailing white space be
ignored, so that, for example " . " and "." are both treated
as missing.}
}
\value{
A vector with "nothing" values replaced by R's NA symbol.
    Does not alter other values in the vector. Previous version
    had applied zapspace to non-missing values, but it no longer
    does so.
}
\description{
By "nothing", we mean white space or other indications of
nothingness.  Goal is to find character strings that users
might insert in a key to indicate missing values. Those things,
which are given default values in the argument nothings, will be
changed to NA.
}
\details{
Using regular expression matching, any value that has nothing
except for the indicated "nothing" values is converted to NA.  The
"nothing" values included by default are a period by itself (A SAS
missing value), an empty string, or white space, meaning " ", or
any number of spaces, or a tab.
}
\examples{
gg <- c("", " ", "   ", "\\t", "\\t some", "some\\t", " space first", ".",
       " . ")
n2NA(x = gg)
n2NA(x = gg, zapspace = FALSE)
n2NA(x = gg, nothings = c("\\\\s"), zapspace = FALSE)
n2NA(x = gg, nothings = c("\\\\."), zapspace = TRUE)
n2NA(x = gg, nothings = c("\\\\."), zapspace = FALSE)
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
