% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_with_methods.R
\name{phs_with}
\alias{phs_with}
\title{Fill multiple placeholders using key value syntax}
\usage{
phs_with(x, ..., .dots = NULL, .slide_idx = NULL)
}
\arguments{
\item{x}{A \code{rpptx} object.}

\item{...}{Key-value pairs of the form \code{"short form location" = object}. If the short form is an integer or a string
with blanks, you must wrap it in quotes or backticks.}

\item{.dots}{List of key-value pairs \code{"short form location" = object}. Alternative to \code{...}.}

\item{.slide_idx}{Numeric indexes of slides to process. \code{NULL} (default) processes the current slide only. Use
keyword \code{all} for all slides.}
}
\description{
A sibling of \link{ph_with} that fills mutiple placeholders at once. Placeholder locations are
specfied using the short form syntax. The location and corresponding object are passed as key value pairs
(\code{phs_with("short form location" = object)}). Under the hood, \link{ph_with} is called for each pair. Note
that \code{phs_with} does not cover all options from the \verb{ph_location_*} family and is also less customization. It is a
covenience wrapper for the most common use cases. The implemented short forms are listed in section
\code{"Short forms"}.
}
\section{Short forms}{
 The following short forms are implemented and can be used as the parameter in the function
call. The corresponding function from the \verb{ph_location_*} family (called under the hood) is displayed on the
right.\tabular{lll}{
   \strong{Short form} \tab \strong{Description} \tab \strong{Location function} \cr
   \code{"left"} \tab Keyword string \tab \code{ph_location_left()} \cr
   \code{"right"} \tab Keyword string \tab \code{ph_location_right()} \cr
   \code{"fullsize"} \tab Keyword string \tab \code{ph_location_fullsize()} \cr
   \code{"body [1]"} \tab String: type + index in brackets (\code{1} if omitted) \tab \code{ph_location_type("body", 1)} \cr
   \code{"my_label"} \tab Any string not matching a keyword or type \tab \code{ph_location_label("my_label")} \cr
   \code{1} \tab Length 1 integer \tab \code{ph_location_id(1)} \cr
}
}

\examples{
library(officer)

# use key-value format to fill phs
x <- read_pptx()
x <- add_slide(x, "Two Content")
x <- phs_with(
  x,
  `Title 1` = "A title", # ph label
  dt = Sys.Date(), # ph type
  `body[2]` = "Body 2", # ph type + type index
  left = "Left side", # ph keyword
  `6` = "Footer" # ph index
)

# reuse ph content via the .dots arg
x <- read_pptx()
my_ph_list <- list(`6` = "Footer", dt = Sys.Date())
x <- add_slide(x, "Two Content")
x <- phs_with(
  x,
  `Title 1` = "Title A",
  `body[2]` = "Body A",
  .dots = my_ph_list
)
x <- add_slide(x, "Two Content")
x <- phs_with(
  x,
  `Title 1` = "Title B",
  `body[2]` = "Body B",
  .dots = my_ph_list
)

# use the .slide_idx arg to select which slide(s) to process
x <- read_pptx()
x <- add_slide(x, "Two Content")
x <- add_slide(x, "Two Content")
x <- phs_with(x, `6` = "Footer", dt = Sys.Date(), .slide_idx = 1:2)

# run to open temp pptx file locally
# \dontrun{
# print(x, preview = TRUE)
# }
}
\seealso{
\code{\link[=ph_with]{ph_with()}}, \code{\link[=add_slide]{add_slide()}}
}
