% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{Math.units}
\alias{Math.units}
\title{Mathematical operations for units objects}
\usage{
\method{Math}{units}(x, ...)
}
\arguments{
\item{x}{object of class units}

\item{...}{parameters passed on to the Math functions}
}
\description{
Mathematical operations for units objects
}
\details{
Logarithms receive a special treatment by the underlying \pkg{udunits2}
library. If a natural logarithm is applied to some \code{unit}, the result is
\code{ln(re 1 unit)}, which means \emph{natural logarithm referenced to
\code{1 unit}}. For base 2 and base 10 logarithms, the output \code{lb(...)}
and \code{lg(...)} respectively instead of \code{ln(...)}.

This is particularly important for some units that are typically expressed in
a logarithmic scale (i.e., \emph{bels}, or, more commonly, \emph{decibels}),
such as Watts or Volts. For some of these units, the default \pkg{udunits2}
database contains aliases: e.g., \code{BW} (bel-Watts) is an alias of
\code{lg(re 1 W)}; \code{Bm} (bel-milliWatts) is an alias of
\code{lg(re 0.001 W)}; \code{BV} is an alias of \code{lg(re 1 V)} (bel-Volts),
and so on and so forth (see the output of \code{valid_udunits()} for further
reference).

Additionally, the \pkg{units} package defines \code{B}, the \emph{bel}, by
default (because it is not defined by \pkg{udunits2}) as an alias of
\code{lg(re 1)}, unless a user-provided XML database already contains a
definition of \code{B}, or the \code{define_bel} option is set to \code{FALSE}
(see \code{help(units_options)}).
}
\examples{
# roundings, cummulative functions
x <- set_units(sqrt(1:10), m/s)
signif(x, 2)
cumsum(x)

# trigonometry
sin(x) # not meaningful
x <- set_units(sqrt(1:10), rad)
sin(x)
cos(x)
x <- set_units(seq(0, 1, 0.1), 1)
asin(x)
acos(x)

# logarithms
x <- set_units(sqrt(1:10), W)
log(x) # base exp(1)
log(x, base = 3)
log2(x)
log10(x)
set_units(x, dBW) # decibel-watts
set_units(x, dBm) # decibel-milliwatts
}
