
// test_simulation_decoder_2_test.v
module f1_test (input [1:0] in, input enable, output reg  out);

always @(in or enable)
    if(!enable)
	    out = 4'b0000;
	else begin
	   case (in)
	       2'b00 : out = 0 ;
	       2'b01 : out = 1;
	       2'b10 : out = 0;
	       2'b11 : out = 1;
	    endcase
	end
endmodule

// test_simulation_decoder_3_test.v
module f2_test (input [1:0] in, input enable, output reg [2:0] out);

always @(in or enable)
    if(!enable)
	    out = 3'b000;
	else begin
	   case (in)
	       2'b00 : out = 3'b001 ;
	       2'b01 : out = 3'b010;
	       2'b10 : out = 3'b010;
	       2'b11 : out = 3'b100;
	    endcase
	end
endmodule

// test_simulation_decoder_4_test.v
module f3_test (input [2:0] in, output reg [7:0] out);

always @(in )
	   case (in)
	       3'b000 : out = 8'b00000001;
	       3'b001 : out = 8'b00000010;
	       3'b010 : out = 8'b00000100;
	       3'b011 : out = 8'b00001000;
	       3'b100 : out = 8'b00010000;
	       3'b101 : out = 8'b00100000;
	       3'b110 : out = 8'b01000000;
	       3'b111 : out = 8'b10000000;
	    endcase
endmodule	

// test_simulation_decoder_5_test.v
module f4_test (input [2:0] in, input enable, output reg [7:0] out);

always @(in or enable )
    if(!enable)
	    out = 8'b00000000;
	else	
	   case (in)
	       3'b000 : out = 8'b00000001;
	       3'b001 : out = 8'b00000010;
	       3'b010 : out = 8'b00000100;
	       3'b011 : out = 8'b00001000;
	       3'b100 : out = 8'b00010000;
	       3'b101 : out = 8'b00100000;
	       3'b110 : out = 8'b01000000;
	       3'b111 : out = 8'b10000000;
	    endcase
endmodule	

// test_simulation_decoder_6_test.v
module f5_test (input [3:0] in, input enable, output reg [15:0] out);

always @(in or enable)
    if(!enable)
	    out = 16'b0000000000000000;
	else begin
	   case (in)
	       4'b0000 : out = 16'b0000000000000001;
	       4'b0001 : out = 16'b0000000000000010;
	       4'b0010 : out = 16'b0000000000000100;
	       4'b0011 : out = 16'b0000000000001000;
	       4'b0100 : out = 16'b0000000000010000;
	       4'b0101 : out = 16'b0000000000100000;
	       4'b0110 : out = 16'b0000000001000000;
	       4'b0111 : out = 16'b0000000010000000;
	       4'b1000 : out = 16'b0000000100000000;
	       4'b1001 : out = 16'b0000001000000000;
	       4'b1010 : out = 16'b0000010000000000;
	       4'b1011 : out = 16'b0000100000000000;
	       4'b1100 : out = 16'b0001000000000000;
	       4'b1101 : out = 16'b0010000000000000;
	       4'b1110 : out = 16'b0100000000000000;
	       4'b1111 : out = 16'b1000000000000000;
	    endcase
	end
endmodule	


// test_simulation_decoder_7_test.v
module f6_test (input [4:0] in, input enable, output reg [31:0] out);

always @(in or enable)
    if(!enable)
	    out = 32'b00000000000000000000000000000000;
	else begin
	   case (in)
	       5'b00000 : out = 32'b00000000000000000000000000000001;
	       5'b00001 : out = 32'b00000000000000000000000000000010;
	       5'b00010 : out = 32'b00000000000000000000000000000100;
	       5'b00011 : out = 32'b00000000000000000000000000001000;
	       5'b00100 : out = 32'b00000000000000000000000000010000;
	       5'b00101 : out = 32'b00000000000000000000000000100000;
	       5'b00110 : out = 32'b00000000000000000000000001000000;
	       5'b00111 : out = 32'b00000000000000000000000010000000;
	       5'b01000 : out = 32'b00000000000000000000000100000000;
	       5'b01001 : out = 32'b00000000000000000000001000000000;
	       5'b01010 : out = 32'b00000000000000000000010000000000;
	       5'b01011 : out = 32'b00000000000000000000100000000000;
	       5'b01100 : out = 32'b00000000000000000001000000000000;
	       5'b01101 : out = 32'b00000000000000000010000000000000;
	       5'b01110 : out = 32'b00000000000000000100000000000000;
	       5'b01111 : out = 32'b00000000000000001000000000000000;
	       5'b10000 : out = 32'b00000000000000010000000000000000;
	       5'b10001 : out = 32'b00000000000000100000000000000000;
	       5'b10010 : out = 32'b00000000000001000000000000000000;
	       5'b10011 : out = 32'b00000000000010000000000000000000;
	       5'b10100 : out = 32'b00000000000100000000000000000000;
	       5'b10101 : out = 32'b00000000001000000000000000000000;
	       5'b10110 : out = 32'b00000000010000000000000000000000;
	       5'b10111 : out = 32'b00000000100000000000000000000000;
	       5'b11000 : out = 32'b00000001000000000000000000000000;
	       5'b11001 : out = 32'b00000010000000000000000000000000;
	       5'b11010 : out = 32'b00000100000000000000000000000000;
	       5'b11011 : out = 32'b00001000000000000000000000000000;
	       5'b11100 : out = 32'b00010000000000000000000000000000;
	       5'b11101 : out = 32'b00100000000000000000000000000000;
	       5'b11110 : out = 32'b01000000000000000000000000000000;
	       5'b11111 : out = 32'b10000000000000000000000000000000;
	    endcase
	end
endmodule	


// test_simulation_decoder_8_test.v
module f7_test (input [5:0] in, input enable, output reg [63:0] out);

always @(in or enable)
    if(!enable)
	    out = 64'b0000000000000000000000000000000000000000000000000000000000000000;
	else begin
	   case (in)
	       6'b000000 : out = 64'b0000000000000000000000000000000000000000000000000000000000000001;
	       6'b000001 : out = 64'b0000000000000000000000000000000000000000000000000000000000000010;
	       6'b000010 : out = 64'b0000000000000000000000000000000000000000000000000000000000000100;
	       6'b000011 : out = 64'b0000000000000000000000000000000000000000000000000000000000001000;
	       6'b000100 : out = 64'b0000000000000000000000000000000000000000000000000000000000010000;
	       6'b000101 : out = 64'b0000000000000000000000000000000000000000000000000000000000100000;
	       6'b000110 : out = 64'b0000000000000000000000000000000000000000000000000000000001000000;
	       6'b000111 : out = 64'b0000000000000000000000000000000000000000000000000000000010000000;
	       6'b001000 : out = 64'b0000000000000000000000000000000000000000000000000000000100000000;
	       6'b001001 : out = 64'b0000000000000000000000000000000000000000000000000000001000000000;
	       6'b001010 : out = 64'b0000000000000000000000000000000000000000000000000000010000000000;
	       6'b001011 : out = 64'b0000000000000000000000000000000000000000000000000000100000000000;
	       6'b001100 : out = 64'b0000000000000000000000000000000000000000000000000001000000000000;
	       6'b001101 : out = 64'b0000000000000000000000000000000000000000000000000010000000000000;
	       6'b001110 : out = 64'b0000000000000000000000000000000000000000000000000100000000000000;
	       6'b001111 : out = 64'b0000000000000000000000000000000000000000000000001000000000000000;
	       6'b010000 : out = 64'b0000000000000000000000000000000000000000000000010000000000000000;
	       6'b010001 : out = 64'b0000000000000000000000000000000000000000000000100000000000000000;
	       6'b010010 : out = 64'b0000000000000000000000000000000000000000000001000000000000000000;
	       6'b010011 : out = 64'b0000000000000000000000000000000000000000000010000000000000000000;
	       6'b010100 : out = 64'b0000000000000000000000000000000000000000000100000000000000000000;
	       6'b010101 : out = 64'b0000000000000000000000000000000000000000001000000000000000000000;
	       6'b010110 : out = 64'b0000000000000000000000000000000000000000010000000000000000000000;
	       6'b010111 : out = 64'b0000000000000000000000000000000000000000100000000000000000000000;
	       6'b011000 : out = 64'b0000000000000000000000000000000000000001000000000000000000000000;
	       6'b011001 : out = 64'b0000000000000000000000000000000000000010000000000000000000000000;
	       6'b011010 : out = 64'b0000000000000000000000000000000000000100000000000000000000000000;
	       6'b011011 : out = 64'b0000000000000000000000000000000000001000000000000000000000000000;
	       6'b011100 : out = 64'b0000000000000000000000000000000000010000000000000000000000000000;
	       6'b011101 : out = 64'b0000000000000000000000000000000000100000000000000000000000000000;
	       6'b011110 : out = 64'b0000000000000000000000000000000001000000000000000000000000000000;
	       6'b011111 : out = 64'b0000000000000000000000000000000010000000000000000000000000000000;

	       6'b100000 : out = 64'b0000000000000000000000000000000100000000000000000000000000000000;
	       6'b100001 : out = 64'b0000000000000000000000000000001000000000000000000000000000000000;
	       6'b100010 : out = 64'b0000000000000000000000000000010000000000000000000000000000000000;
	       6'b100011 : out = 64'b0000000000000000000000000000100000000000000000000000000000000000;
	       6'b100100 : out = 64'b0000000000000000000000000001000000000000000000000000000000000000;
	       6'b100101 : out = 64'b0000000000000000000000000010000000000000000000000000000000000000;
	       6'b100110 : out = 64'b0000000000000000000000000100000000000000000000000000000000000000;
	       6'b100111 : out = 64'b0000000000000000000000001000000000000000000000000000000000000000;
	       6'b101000 : out = 64'b0000000000000000000000010000000000000000000000000000000000000000;
	       6'b101001 : out = 64'b0000000000000000000000100000000000000000000000000000000000000000;
	       6'b101010 : out = 64'b0000000000000000000001000000000000000000000000000000000000000000;
	       6'b101011 : out = 64'b0000000000000000000010000000000000000000000000000000000000000000;
	       6'b101100 : out = 64'b0000000000000000000100000000000000000000000000000000000000000000;
	       6'b101101 : out = 64'b0000000000000000001000000000000000000000000000000000000000000000;
	       6'b101110 : out = 64'b0000000000000000010000000000000000000000000000000000000000000000;
	       6'b101111 : out = 64'b0000000000000000100000000000000000000000000000000000000000000000;
	       6'b110000 : out = 64'b0000000000000001000000000000000000000000000000000000000000000000;
	       6'b110001 : out = 64'b0000000000000010000000000000000000000000000000000000000000000000;
	       6'b110010 : out = 64'b0000000000000100000000000000000000000000000000000000000000000000;
	       6'b110011 : out = 64'b0000000000001000000000000000000000000000000000000000000000000000;
	       6'b110100 : out = 64'b0000000000010000000000000000000000000000000000000000000000000000;
	       6'b110101 : out = 64'b0000000000100000000000000000000000000000000000000000000000000000;
	       6'b110110 : out = 64'b0000000001000000000000000000000000000000000000000000000000000000;
	       6'b110111 : out = 64'b0000000010000000000000000000000000000000000000000000000000000000;
	       6'b111000 : out = 64'b0000000100000000000000000000000000000000000000000000000000000000;
	       6'b111001 : out = 64'b0000001000000000000000000000000000000000000000000000000000000000;
	       6'b111010 : out = 64'b0000010000000000000000000000000000000000000000000000000000000000;
	       6'b111011 : out = 64'b0000100000000000000000000000000000000000000000000000000000000000;
	       6'b111100 : out = 64'b0001000000000000000000000000000000000000000000000000000000000000;
	       6'b111101 : out = 64'b0010000000000000000000000000000000000000000000000000000000000000;
	       6'b111110 : out = 64'b0100000000000000000000000000000000000000000000000000000000000000;
	       6'b111111 : out = 64'b1000000000000000000000000000000000000000000000000000000000000000;
	    endcase
	end
endmodule	

