/*****************************************************************************
 * program.h : SAP programs classes definition
 ****************************************************************************
 * Copyright (C) 1998-2002 VideoLAN
 * $Id: program.h,v 1.3 2003/05/25 21:41:19 alexis Exp $ 
 *
 * Authors: Damien Lucas <nitrox@videolan.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/


class Program
{
  public:
    Program(string, string, string, string, string,string);
    Program();
    ~Program();
    string GetName();
    string GetUser();
    string GetMachine();
    string GetSite();
    string GetAddress();
    string GetPort();
    void SetName(char*);
    void SetUser(char*);
    void SetMachine(char*);
    void SetSite(char*);
    void SetAddress(char*);
    void SetPort(char *);
    bool IsPermanent();

  private:
    string name;
    string user;
    string machine;
    string site;
    string address;
    string port;
    bool permanent;
    uint32_t start_time;
    uint32_t stop_time;
    /* TODO support for periodical programs */
};
