/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.common.adapters;

import java.io.Serializable;

import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.VlServer;

/**
 * Abstract basic implementation of IVlAdapter. Defines methods common to several 
 * adapters.
 *
 * @see IVlAdapter
 * @see VlDVBS
 * @author SylV
 * @version 1.0
 * 
 */
public abstract class VlAdapter implements Serializable, IVlAdapter {
    
    private String name;
    
    private VlServer server;

    private boolean isUp;

    public boolean isUp() {
        return isUp;
    }

    public void setUp(boolean isUp) {
        this.isUp = isUp;
    }

    public VlAdapter() {
        name = "";
        setUp(true);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    
    public VlServer getServer() {
        return server;
    }
    
    public void setServer(VlServer server) {
        this.server = server;
    }

    public int hashType() {
        return 0;
    }

    public boolean canRead(IVlMedia media) {
        return false;
    }
}
