/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.TimeMarker;

public class TimeAxisUnit {
    private static final int[] calendarUnit = new int[]{13, 12, 11, 5, 3, 2, 1};
    public static final int SECOND = 0;
    public static final int MINUTE = 1;
    public static final int HOUR = 2;
    public static final int DAY = 3;
    public static final int WEEK = 4;
    public static final int MONTH = 5;
    public static final int YEAR = 6;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int SUNDAY = 1;
    private static final String[] UNIT_NAMES = new String[]{"SECOND", "MINUTE", "HOUR", "DAY", "WEEK", "MONTH", "YEAR"};
    private static final String[] DAY_NAMES = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
    private int minGridTimeUnit = 2;
    private int minGridUnitSteps = 1;
    private int majGridTimeUnit = 2;
    private int majGridUnitSteps = 6;
    private boolean centerLabels = false;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm", Locale.ENGLISH);
    private int firstDayOfWeek = 2;

    TimeAxisUnit(int n, int n2, int n3, int n4, SimpleDateFormat simpleDateFormat, boolean bl, int n5) {
        this.minGridTimeUnit = n;
        this.minGridUnitSteps = n2;
        this.majGridTimeUnit = n3;
        this.majGridUnitSteps = n4;
        this.dateFormat = new SimpleDateFormat(simpleDateFormat.toPattern(), Locale.ENGLISH);
        this.centerLabels = bl;
        this.firstDayOfWeek = n5;
    }

    TimeMarker[] getTimeMarkers(long l, long l2) {
        l2 *= 1000L;
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        this.setStartPoint(calendar, this.majGridTimeUnit, l *= 1000L);
        this.setStartPoint(calendar2, this.minGridTimeUnit, l);
        long l3 = calendar2.getTimeInMillis();
        long l4 = calendar.getTimeInMillis();
        while (l4 < l) {
            l4 = this.getNextPoint(calendar, this.majGridTimeUnit, this.majGridUnitSteps);
        }
        while (l3 < l) {
            l3 = this.getNextPoint(calendar2, this.minGridTimeUnit, this.minGridUnitSteps);
        }
        ArrayList<TimeMarker> arrayList = new ArrayList<TimeMarker>();
        while (l3 <= l2 && l4 <= l2) {
            if (l3 < l4) {
                arrayList.add(new TimeMarker(l3, "", false));
                l3 = this.getNextPoint(calendar2, this.minGridTimeUnit, this.minGridUnitSteps);
                continue;
            }
            if (l3 == l4) {
                arrayList.add(new TimeMarker(l4, this.dateFormat.format(calendar.getTime()), true));
                l4 = this.getNextPoint(calendar, this.majGridTimeUnit, this.majGridUnitSteps);
                l3 = this.getNextPoint(calendar2, this.minGridTimeUnit, this.minGridUnitSteps);
                continue;
            }
            arrayList.add(new TimeMarker(l4, this.dateFormat.format(calendar.getTime()), true));
            l4 = this.getNextPoint(calendar, this.majGridTimeUnit, this.majGridUnitSteps);
        }
        while (l3 <= l2) {
            arrayList.add(new TimeMarker(l3, "", false));
            l3 = this.getNextPoint(calendar2, this.minGridTimeUnit, this.minGridUnitSteps);
        }
        while (l4 <= l2) {
            arrayList.add(new TimeMarker(l4, this.dateFormat.format(calendar.getTime()), true));
            l4 = this.getNextPoint(calendar, this.majGridTimeUnit, this.majGridUnitSteps);
        }
        return arrayList.toArray(new TimeMarker[0]);
    }

    long getMajorGridWidth() {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis() / 1000L;
        calendar.add(calendarUnit[this.majGridTimeUnit], this.majGridUnitSteps);
        return calendar.getTimeInMillis() / 1000L - l;
    }

    boolean getCenterLabels() {
        return this.centerLabels;
    }

    int getMinGridTimeUnit() {
        return this.minGridTimeUnit;
    }

    int getMinGridUnitSteps() {
        return this.minGridUnitSteps;
    }

    int getMajGridTimeUnit() {
        return this.majGridTimeUnit;
    }

    int getMajGridUnitSteps() {
        return this.majGridUnitSteps;
    }

    boolean isCenterLabels() {
        return this.centerLabels;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    private void setStartPoint(Calendar calendar, int n, long l) {
        calendar.setTimeInMillis(l);
        calendar.setFirstDayOfWeek(this.firstDayOfWeek);
        for (int i = 0; i < 2 && i <= n; ++i) {
            calendar.set(calendarUnit[i], 0);
        }
        if (n >= 2) {
            calendar.set(11, 0);
        }
        if (n == 4) {
            calendar.set(7, calendar.getFirstDayOfWeek());
        } else if (n == 5) {
            calendar.set(5, 1);
        } else if (n == 6) {
            calendar.set(5, 1);
            calendar.set(2, 0);
        }
    }

    private long getNextPoint(Calendar calendar, int n, int n2) {
        calendar.add(calendarUnit[n], n2);
        return calendar.getTimeInMillis();
    }

    static String getUnitName(int n) {
        return UNIT_NAMES[n];
    }

    static String getDayName(int n) {
        return DAY_NAMES[n];
    }

    void exportXmlTemplate(XmlWriter xmlWriter) {
        xmlWriter.startTag("time_axis");
        xmlWriter.writeTag("min_grid_time_unit", TimeAxisUnit.getUnitName(this.getMinGridTimeUnit()));
        xmlWriter.writeTag("min_grid_unit_steps", this.getMinGridUnitSteps());
        xmlWriter.writeTag("maj_grid_time_unit", TimeAxisUnit.getUnitName(this.getMajGridTimeUnit()));
        xmlWriter.writeTag("maj_grid_unit_steps", this.getMajGridUnitSteps());
        xmlWriter.writeTag("date_format", this.getDateFormat().toPattern());
        xmlWriter.writeTag("center_labels", this.getCenterLabels());
        if (this.firstDayOfWeek != 2) {
            xmlWriter.writeTag("first_day_of_week", TimeAxisUnit.getDayName(this.firstDayOfWeek));
        }
        xmlWriter.closeTag();
    }
}

