/*
 * Copyright (C) 2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.client

import groovy.swing.SwingBuilder
import java.awt.*
import java.rmi.registry.*
import javax.swing.*

import org.videolan.vlma.Data

/**
 * A sample Swing client for VLMa daemon.
 */
class Client {

    private static data

    static getData() {
        if (data != null) {
            return data
        } else {
            def registry = LocateRegistry.getRegistry(9050)
            data = (Data) registry.lookup("VLMaDataService")
            return data
        }
    }

    static void main(args) {
        def swing = new SwingBuilder()
        def frame = swing.frame(title: "VLMa Swing Client",
                layout: new BorderLayout(),
                defaultCloseOperation: JFrame.EXIT_ON_CLOSE
        ) {
            tabbedPane(tabPlacement: JTabbedPane.TOP) {
                panel(name: "Welcome", constraints:BorderLayout.CENTER, layout: new BorderLayout()) {
                    label(text: "Streaming state", constraints:BorderLayout.NORTH)
                    panel(constraints:BorderLayout.CENTER) {
                        scrollPane() {
                            streamedMedias = new JTable((String[][]) getData().getMedias()
                                    .findAll({ it.getProgram() != null })
                                    .collect({ [it.getName(), it.getProgram().getPriority(), it.getProgram().getPlayer() ?: "Not assigned"] }),
                                    (String[]) ["Name", "Priority", "Assigned to"])
                            widget(streamedMedias)
                        }
                    }
                }
                panel(name: "Servers", constraints:BorderLayout.CENTER, layout: new BorderLayout()) {
                    label(text: "Servers", constraints:BorderLayout.NORTH)
                    panel(constraints:BorderLayout.CENTER) {
                        scrollPane() {
                            servers = new JTable((String[][]) getData().getServers()
                                    .collect({ [it.getName(), it.getIp(), it.isUp() ? "Yes" : "No"] }),
                                    (String[]) ["Name", "Address", "Up?"])
                            widget(servers)
                        }
                    }
                }
            }
        }
        frame.pack()
        frame.setSize(250, 300);
        frame.show()
    }

}
