/*******************************************************************************
* channel.cpp: Channel encapsulation
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: channel.cpp,v 1.1 2001/10/06 21:23:36 bozo Exp $
*
* Authors: Benoit Steiner <benny@via.ecp.fr>
*          Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Preamble
//------------------------------------------------------------------------------
#include "../core/defs.h"

#include "config.h"
#include "../core/core.h"
#include "../mpeg/mpeg.h"
#include "../mpeg/ts.h"
#include "buffer.h"
#include "output.h"
#include "channel.h"



//******************************************************************************
// class C_Channel
//******************************************************************************
//
//******************************************************************************

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_Channel::C_Channel(const C_String& strName) : m_strName(strName)
{
  m_bIsFree = true;
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_Channel::~C_Channel()
{
  ASSERT(m_pOutput);
  delete m_pOutput;
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_Output* C_Channel::GetOutput()
{
  // Pb of race condition -> put a lock in the future ?
  ASSERT(m_bIsFree);
  m_bIsFree = false;

  ASSERT(m_pOutput);
  return m_pOutput;
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_Channel::ReleaseOutput()
{
  ASSERT(m_pOutput);
  ASSERT(!m_bIsFree);
  m_bIsFree = true;
}




//******************************************************************************
// class C_NetChannel
//******************************************************************************
//
//******************************************************************************

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_NetChannel::C_NetChannel(const C_String& strName) : C_Channel(strName)
{
  C_Application* pApp = C_Application::GetApp();
  ASSERT(pApp);

  C_String strInterface = pApp->GetSetting(m_strName+".Interface", "");
  C_String strSrcHost = pApp->GetSetting(m_strName+".SrcHost", "0.0.0.0");
  C_String strSrcPort = pApp->GetSetting(m_strName+".SrcPort", "1234");
  C_String strDstHost = pApp->GetSetting(m_strName+".DstHost", "239.0.0.3");
  C_String strDstPort = pApp->GetSetting(m_strName+".DstPort", "1234");

  m_pOutput = new C_NetOutput(strInterface,
                              strSrcHost, strSrcPort, strDstHost, strDstPort);
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
/*C_String C_NetChannel::GetConfig()
{
  return m_strConfig;
}*/

