# -*- coding: utf-8 -*-
#from __future__ import unicode_literals

#from future import standard_library
import math
import time

import xbmc, xbmcaddon

from dateutil.parser import parse
import socket, urllib.request
import json

#standard_library.install_aliases()


ADDON       = xbmcaddon.Addon()
ADDONID     = ADDON.getAddonInfo('id')
LANGUAGE    = ADDON.getLocalizedString
DEBUG       = ADDON.getSetting('Debug')
TEMPUNIT    = xbmc.getRegion('tempunit')
SPEEDUNIT   = xbmc.getRegion('speedunit')
DATEFORMAT  = xbmc.getRegion('dateshort')
TIMEFORMAT  = xbmc.getRegion('meridiem')




def log(txt):
    if DEBUG == 'true':
        message = u'%s: %s' % (ADDONID, txt)
        xbmc.log(msg=message, level=xbmc.LOGDEBUG)




def get_url_JSON(url):
    try:
        xbmc.log('fetching url: %s' % url,level=xbmc.LOGDEBUG)
        try:
            timeout = 30
            socket.setdefaulttimeout(timeout)
            # this call to urllib.request.urlopen now uses the default timeout
            # we have set in the socket module
            req = urllib.request.Request(url)
            req.add_header('User-Agent', ' Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.9.0.3) Gecko/2008092417 Firefox/3.0.3')
            try:
                response = urllib.request.urlopen(req)
            except:
                time.sleep(60)
                response = urllib.request.urlopen(req)
                
            responsedata = response.read()
            data = json.loads(responsedata)
            log('data: %s' % data)
            # Happy path, we found and parsed data
            return data
        except:
            xbmc.log('failed to parse json: %s' % url,level=xbmc.LOGERROR)
            xbmc.log('data: %s' % data,level=xbmc.LOGERROR)
    except:
        xbmc.log('failed to fetch : %s' % url,level=xbmc.LOGERROR)
    return None



def get_url_response(url):
    try:
        xbmc.log('fetching url: %s' % url,level=xbmc.LOGDEBUG)
        timeout = 30
        socket.setdefaulttimeout(timeout)
        # this call to urllib.request.urlopen now uses the default timeout
        # we have set in the socket module
        req = urllib.request.Request(url)
        req.add_header('User-Agent', ' Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.9.0.3) Gecko/2008092417 Firefox/3.0.3')

        try:
            response = urllib.request.urlopen(req)
        except:
            time.sleep(60)
            response = urllib.request.urlopen(req)

        responsedata = response.read()
        log('data: %s' % responsedata)
        # Happy path, we found and parsed data
        return responsedata
    except:
        xbmc.log('failed to fetch : %s' % url,level=xbmc.LOGERROR)
    return None

def get_url_image(url,destination):
    try:
        urllib.request.urlretrieve(url, destination)
        return destination
    except:
        xbmc.log('failed to fetch : %s' % url,level=xbmc.LOGERROR)
    return None


WEATHER_CODES = {

        'day/skc':                  '32', #'Fair/clear'
        'day/few':                  '30', #'A few clouds'
        'day/sct':                  '30', #'Partly cloudy'
        'day/bkn':                  '28', #'Mostly cloudy'
        'day/ovc':                  '26', #'Overcast'
        'day/wind_skc':             '24', #'Fair/clear and windy'
        'day/wind_few':             '30', #'A few clouds and windy'
        'day/wind_sct':             '30', #'Partly cloudy and windy'
        'day/wind_bkn':             '28', #'Mostly cloudy and windy'
        'day/wind_ovc':             '26', #'Overcast and windy'
        'day/snow':                 '16', #'Snow'
        'day/sn':                   '16', #'Snow'
        'day/rain_snow':             '5', #'Rain/snow'
        'day/rasn':                  '5', #'Rain/snow'
        'day/rain_sleet':            '6', #'Rain/sleet'
        'day/rasl':                  '6', #'Rain/sleet'
        'day/snow_sleet':            '7', #'Snow/sleet'
        'day/snsl':                  '7', #'Snow/sleet'
        'day/fzra':                 '10', #'Freezing rain'
        'day/rain_fzra':            '10', #'Rain/freezing rain'
        'day/snow_fzra':            '10', #'Freezing rain/snow'
        'day/sleet':                '18', #'Sleet'
        'day/rain':                 '40', #'Rain'
        'day/ra':                   '40', #'Rain' (forecast.gov)
        'day/rain_showers':         '11', #'Rain showers (high cloud cover)'
        'day/shrs':                 '11', #'Rain showers forecast.gov'
        'day/rain_showers_hi':      '12', #'Rain showers (low cloud cover)'
        'day/hi_shrs':              '12', #'Rain showers (low cloud cover)'
        'day/tsra':                 '37', #'Thunderstorm (high cloud cover)'
        'day/tsra_sct':             '38', #'Thunderstorm (medium cloud cover)'
        'day/tsra_hi':              '39', #'Thunderstorm (low cloud cover)'
        'day/tornado':               '0', #'Tornado'
        'day/hurricane':             '2', #'Hurricane conditions'
        'day/tropical_storm':        '1', #'Tropical storm conditions'
        'day/dust':                 '19', #'Dust'
        'day/smoke':                '22', #'Smoke'
        'day/haze':                 '21', #'Haze'
        'day/hot':                  '36', #'Hot'
        'day/cold':                 '25', #'Cold'
        'day/blizzard':             '15', #'Blizzard'
        'day/fog':                  '20', #'Fog/mist'

                
        'night/skc':                '31', #'Fair/clear'
        'night/few':                '29', #'A few clouds'
        'night/sct':                '29', #'Partly cloudy'
        'night/bkn':                '27', #'Mostly cloudy'
        'night/ovc':                '26', #'Overcast'
        'night/wind_skc':           '24', #'Fair/clear and windy'
        'night/wind_few':           '29', #'A few clouds and windy'
        'night/wind_sct':           '29', #'Partly cloudy and windy'
        'night/wind_bkn':           '27', #'Mostly cloudy and windy'
        'night/wind_ovc':           '26', #'Overcast and windy'
        'night/snow':               '16', #'Snow'
        'night/rain_snow':           '5', #'Rain/snow'
        'night/rain_sleet':          '6', #'Rain/sleet'
        'night/snow_sleet':          '7', #'Rain/sleet'
        'night/fzra':               '10', #'Freezing rain'
        'night/rain_fzra':          '10', #'Rain/freezing rain'
        'night/snow_fzra':          '10', #'Freezing rain/snow'
        'night/sleet':              '18', #'Sleet'
        'night/rain':               '40', #'Rain'
        'night/rain_showers':       '11', #'Rain showers (high cloud cover)'
        'night/rain_showers_hi':    '12', #'Rain showers (low cloud cover)'
        'night/tsra':               '37', #'Thunderstorm (high cloud cover)'
        'night/tsra_sct':           '38', #'Thunderstorm (medium cloud cover)'
        'night/tsra_hi':            '39', #'Thunderstorm (low cloud cover)'
        'night/tornado':             '0', #'Tornado'
        'night/hurricane':           '2', #'Hurricane conditions'
        'night/tropical_storm':      '1', #'Tropical storm conditions'
        'night/dust':               '19', #'Dust'
        'night/smoke':              '22', #'Smoke'
        'night/haze':               '21', #'Haze'
        'night/hot':                '36', #'Hot'
        'night/cold':               '25', #'Cold'
        'night/blizzard':           '15', #'Blizzard'
        'night/fog':                '20', #'Fog/mist'

        # special hanlding of forecast.weather.com url patterns that use "nxyz" pattersn for night
        'day/nskc':             '31', #'Fair/clear'
        'day/nfew':             '29', #'A few clouds'
        'day/nsct':             '29', #'Partly cloudy'
        'day/nbkn':             '27', #'Mostly cloudy'
        'day/novc':             '26', #'Overcast'
        'day/nwind_skc':        '24', #'Fair/clear and windy'
        'day/nwind_few':        '29', #'A few clouds and windy'
        'day/nwind_sct':        '29', #'Partly cloudy and windy'
        'day/nwind_bkn':        '27', #'Mostly cloudy and windy'
        'day/nwind_ovc':        '26', #'Overcast and windy'
        'day/nsn':              '16', #'Snow'
        'day/nrasn':             '5', #'Rain/snow'
        'day/nrasl':             '6', #'Rain/sleet'
        'day/nsnsl':             '7', #'Rain/sleet'
        'day/nfzra':            '10', #'Freezing rain'
        'day/nrafzra':          '10', #'Rain/freezing rain'
        'day/nsnfzra':          '10', #'Freezing rain/snow'
        'day/nsl':              '18', #'Sleet'
        'day/nra':              '40', #'Rain'
        'day/nshra':            '11', #'Rain showers (high cloud cover)'
        'day/hi_nshra':         '12', #'Rain showers (low cloud cover)'
        'day/ntsra':            '37', #'Thunderstorm (high cloud cover)'
        'day/ntsra_sct':        '38', #'Thunderstorm (medium cloud cover)'
        'day/ntsra_hi':         '39', #'Thunderstorm (low cloud cover)'
        'day/ntornado':          '0', #'Tornado'
        'day/nhurricane':        '2', #'Hurricane conditions'
        'day/ntropical_storm':   '1', #'Tropical storm conditions'
        'day/ndust':            '19', #'Dust'
        'day/nsmoke':           '22', #'Smoke'
        'day/nhaze':            '21', #'Haze'
        'day/nhot':             '36', #'Hot'
        'day/ncold':            '25', #'Cold'
        'day/nblizzard':        '15', #'Blizzard'
        'day/nfog':             '20', #'Fog/mist'
         '': 'na' 
    }

MONTH_NAME_LONG = { '01' : 21,
        '02' : 22,
        '03' : 23,
        '04' : 24,
        '05' : 25,
        '06' : 26,
        '07' : 27,
        '08' : 28,
        '09' : 29,
        '10' : 30,
        '11' : 31,
        '12' : 32 
    }

MONTH_NAME_SHORT = { '01' : 51,
        '02' : 52,
        '03' : 53,
        '04' : 54,
        '05' : 55,
        '06' : 56,
        '07' : 57,
        '08' : 58,
        '09' : 59,
        '10' : 60,
        '11' : 61,
        '12' : 62 
    }

WEEK_DAY_LONG = { '0' : 17,
        '1' : 11,
        '2' : 12,
        '3' : 13,
        '4' : 14,
        '5' : 15,
        '6' : 16 
    }

WEEK_DAY_SHORT = { '0' : 47,
        '1' : 41,
        '2' : 42,
        '3' : 43,
        '4' : 44,
        '5' : 45,
        '6' : 46 
    }

FORECAST = { 
        'thunderstorm with light rain': LANGUAGE(32201),
        'thunderstorm with rain':       LANGUAGE(32202),
        'thunderstorm with heavy rain': LANGUAGE(32203),
        'light thunderstorm':           LANGUAGE(32204),
        'thunderstorm':                 LANGUAGE(32205),
        'heavy thunderstorm':           LANGUAGE(32206),
        'ragged thunderstorm':          LANGUAGE(32207),
        'thunderstorm with light drizzle': LANGUAGE(32208),
        'thunderstorm with drizzle':    LANGUAGE(32209),
        'thunderstorm with heavy drizzle': LANGUAGE(32210),
        'light intensity drizzle':      LANGUAGE(32211),
        'drizzle':                      LANGUAGE(32212),
        'heavy intensity drizzle':      LANGUAGE(32213),
        'light intensity drizzle rain': LANGUAGE(32214),
        'drizzle rain':                 LANGUAGE(32215),
        'heavy intensity drizzle rain': LANGUAGE(32216),
        'shower rain And drizzle':      LANGUAGE(32217),
        'heavy shower rain and drizzle': LANGUAGE(32218),
        'shower drizzle':               LANGUAGE(32219),
        'light rain':                   LANGUAGE(32220),
        'moderate rain':                LANGUAGE(32221),
        'heavy intensity rain':         LANGUAGE(32222),
        'very heavy rain':              LANGUAGE(32223),
        'extreme rain':                 LANGUAGE(32224),
        'freezing rain':                LANGUAGE(32225),
        'light intensity shower rain':  LANGUAGE(32226),
        'shower rain':                  LANGUAGE(32227),
        'heavy intensity shower rain':  LANGUAGE(32228),
        'ragged shower rain':           LANGUAGE(32229),
        'light snow':                   LANGUAGE(32230),
        'snow':                         LANGUAGE(32231),
        'heavy snow':                   LANGUAGE(32232),
        'sleet':                        LANGUAGE(32233),
        'shower sleet':                 LANGUAGE(32234),
        'light rain and snow':          LANGUAGE(32235),
        'rain and snow':                LANGUAGE(32236),
        'light shower snow':            LANGUAGE(32237),
        'shower snow':                  LANGUAGE(32238),
        'heavy shower snow':            LANGUAGE(32239),
        'mist':                         LANGUAGE(32240),
        'smoke':                        LANGUAGE(32241),
        'haze':                         LANGUAGE(32242),
        'sand, dust whirls':            LANGUAGE(32243),
        'fog':                          LANGUAGE(32244),
        'sand':                         LANGUAGE(32245),
        'dust':                         LANGUAGE(32246),
        'volcanic ash':                 LANGUAGE(32247),
        'squalls':                      LANGUAGE(32248),
        'tornado':                      LANGUAGE(32249),
        'clear sky':                    LANGUAGE(32250),
        'few clouds':                   LANGUAGE(32251),
        'scattered clouds':             LANGUAGE(32252),
        'broken clouds':                LANGUAGE(32253),
        'overcast clouds':              LANGUAGE(32254),
        'tornado':                      LANGUAGE(32255),
        'tropical storm':               LANGUAGE(32256),
        'hurricane':                    LANGUAGE(32257),
        'cold':                         LANGUAGE(32258),
        'hot':                          LANGUAGE(32259),
        'windy':                        LANGUAGE(32260),
        'hail':                         LANGUAGE(32261),
        'calm':                         LANGUAGE(32262),
        'light breeze':                 LANGUAGE(32263),
        'gentle breeze':                LANGUAGE(32264),
        'moderate breeze':              LANGUAGE(32265),
        'fresh breeze':                 LANGUAGE(32266),
        'strong breeze':                LANGUAGE(32267),
        'high wind, near gale':         LANGUAGE(32268),
        'gale':                         LANGUAGE(32269),
        'severe gale':                  LANGUAGE(32270),
        'storm':                        LANGUAGE(32271),
        'violent storm':                LANGUAGE(32272),
        'hurricane':                    LANGUAGE(32273),
        'clear':                        LANGUAGE(32274),
        'clouds':                       LANGUAGE(32275),
        'rain':                         LANGUAGE(32276) 
    }

#def SPEED(mps):
#    try:
#        val = float(mps)
#    except:
#        return ''
#
#    if SPEEDUNIT == 'km/h':
#        speed = mps * 3.6
#    elif SPEEDUNIT == 'm/min':
#        speed = mps * 60
#    elif SPEEDUNIT == 'ft/h':
#        speed = mps * 11810.88
#    elif SPEEDUNIT == 'ft/min':
#        speed = mps * 196.84
#    elif SPEEDUNIT == 'ft/s':
#        speed = mps * 3.281
#    elif SPEEDUNIT == 'mph':
#        speed = mps * 2.237
#    elif SPEEDUNIT == 'knots':
#        speed = mps * 1.944
#    elif SPEEDUNIT == 'Beaufort':
#        speed = KPHTOBFT(mps* 3.6)
#    elif SPEEDUNIT == 'inch/s':
#        speed = mps * 39.37
#    elif SPEEDUNIT == 'yard/s':
#        speed = mps * 1.094
#    elif SPEEDUNIT == 'Furlong/Fortnight':
#        speed = mps * 6012.886
#    else:
#        speed = mps
#    return str(int(round(speed)))



def FtoC(Fahrenheit):
    try:
        Celsius = (float(Fahrenheit) - 32.0) * 5.0/9.0 
        return Celsius 
    except:
        return
        
def CtoF(Celsius):
    try:
        Fahrenheit = (float(Celsius) * 9.0/5.0) + 32.0
        return Fahrenheit 
    except:
        return



def TEMP(deg):
    if TEMPUNIT == u'\N{DEGREE SIGN}'+'F':
        temp = deg * 1.8 + 32
    elif TEMPUNIT == u'K':
        temp = deg + 273.15
    elif TEMPUNIT == u'°Ré':
        temp = deg * 0.8
    elif TEMPUNIT == u'°Ra':
        temp = deg * 1.8 + 491.67
    elif TEMPUNIT == u'°Rø':
        temp = deg * 0.525 + 7.5
    elif TEMPUNIT == u'°D':
        temp = deg / -0.667 + 150
    elif TEMPUNIT == u'°N':
        temp = deg * 0.33
    else:
        temp = deg
    return str(int(round(temp)))

def WIND_DIR(deg):
    if deg >= 349 or deg <= 11:
        return 71
    elif deg >= 12 and deg <= 33:
        return 72
    elif deg >= 34 and deg <= 56:
        return 73
    elif deg >= 57 and deg <= 78:
        return 74
    elif deg >= 79 and deg <= 101:
        return 75
    elif deg >= 102 and deg <= 123:
        return 76
    elif deg >= 124 and deg <= 146:
        return 77
    elif deg >= 147 and deg <= 168:
        return 78
    elif deg >= 169 and deg <= 191:
        return 79
    elif deg >= 192 and deg <= 213:
        return 80
    elif deg >= 214 and deg <= 236:
        return 81
    elif deg >= 237 and deg <= 258:
        return 82
    elif deg >= 259 and deg <= 281:
        return 83
    elif deg >= 282 and deg <= 303:
        return 84
    elif deg >= 304 and deg <= 326:
        return 85
    elif deg >= 327 and deg <= 348:
        return 86

#def KPHTOBFT(spd):
#    if (spd < 1.0):
#        bft = '0'
#    elif (spd >= 1.0) and (spd < 5.6):
#        bft = '1'
#    elif (spd >= 5.6) and (spd < 12.0):
#        bft = '2'
#    elif (spd >= 12.0) and (spd < 20.0):
#        bft = '3'
#    elif (spd >= 20.0) and (spd < 29.0):
#        bft = '4'
#    elif (spd >= 29.0) and (spd < 39.0):
#        bft = '5'
#    elif (spd >= 39.0) and (spd < 50.0):
#        bft = '6'
#    elif (spd >= 50.0) and (spd < 62.0):
#        bft = '7'
#    elif (spd >= 62.0) and (spd < 75.0):
#        bft = '8'
#    elif (spd >= 75.0) and (spd < 89.0):
#        bft = '9'
#    elif (spd >= 89.0) and (spd < 103.0):
#        bft = '10'
#    elif (spd >= 103.0) and (spd < 118.0):
#        bft = '11'
#    elif (spd >= 118.0):
#        bft = '12'
#    else:
#        bft = ''
#    return bft


    
def FEELS_LIKE_C_KPH(Ts, Vs=0, Hs=0):
    #xbmc.log('Running FEELS_LIKE_C_KPH: %s %s %s' % (Ts, Vs, Hs),level=xbmc.LOGERROR)
    if not Vs:
        Vs=0
    T=float(Ts)
    V=float(Vs)
    H=float(Hs)
    # first check if we have a wind-chill value    
    windchill =    WIND_CHILL_C_KPH(T, V)
    if windchill and windchill < T :    
        return windchill
    else:         # otherwise, check for heat index
        heatindex = HEAT_INDEX_C(T, H)
        if heatindex and heatindex > T and heatindex > 80 :
            return heatindex
    # otherwise, neither windchill nor heatindex apply
    #xbmc.log('FEELS_LIKE_C_KPH: Not Applicable',level=xbmc.LOGERROR)
    return


def FEELS_LIKE_F_MPH(Ts, Vs=0, Hs=0):
    #xbmc.log('Running FEELS_LIKE_F_MPH: %s %s %s' % (Ts, Vs, Hs),level=xbmc.LOGERROR)

    if not Vs:
        Vs=0
    T=float(Ts)
    V=float(Vs)
    H=float(Hs)
    #xbmc.log('Running FEELS_LIKE_F_MPH: %s %s %s' % (T, V, H),level=xbmc.LOGERROR)
    # first check if we have a wind-chill value    
    windchill = WIND_CHILL_F_MPH(T, V)
    #xbmc.log('windchill returns: %s' % (windchill),level=xbmc.LOGERROR)

    if windchill and windchill < T:    
        return windchill
    else:         # otherwise, check for heat index
        heatindex = HEAT_INDEX_F(T, H)
        ##xbmc.log'heatindex returns: %s' % (heatindex),level=xbmc.LOGERROR)

        if heatindex and heatindex > T+2 and heatindex > 80 :
            return heatindex
    # otherwise, neither windchill nor heatindex apply
    #xbmc.log('FEELS_LIKE_F_MPH: Not Applicable',level=xbmc.LOGERROR)
    return
        

def WIND_CHILL_F_MPH(Ts, Vs):
    T=float(Ts)
    V=float(Vs)
    ##xbmc.log('wind_chill_f_mph    %s %s' % (T, V),level=xbmc.LOGERROR)
    if T <= 50.0 and V >= 3.0:
        #xbmc.log('We are in windchill range %s' % (T),level=xbmc.LOGERROR)
        WC=35.74 + (0.6215 * T) - (35.75 * math.pow(V,0.16)) + (0.4275 * T * math.pow(V,0.16))
        ##xbmc.log('WindChill for %sF %s mph = %sF' % (T, V, WC),level=xbmc.LOGERROR)
        if WC < T-2.0:
            #xbmc.log('WindChill for %sF %s mph = %sF' % (T, V, WC),level=xbmc.LOGERROR)
            return WC
            
    # otherwise, windchill is not relevant, so return
    return
    
    
def WIND_CHILL_C_KPH(Ts, Vs):
    T=float(Ts)
    V=float(Vs)
    TF = CtoF(T)
    Vmph = V/1.609344
    windchill=WIND_CHILL_F_MPH(TF,Vmph)
    if windchill:
        return FtoC(windchill)
    # otherwise, no windchill so return
    return


# https://www.wpc.ncep.noaa.gov/html/heatindex_equation.shtml
def HEAT_INDEX_F(Ts, Rs):
    T=float(Ts)
    R=float(Rs)
    ##xbmc.log'Heat_index_F %sF %s' % (T, R),level=xbmc.LOGERROR)
    if T <40:    # too cold for heat indexes
        return
    # Try simple formula first
    HI = 0.5 * (T + 61.0 + ((T-68.0)*1.2) + (R*0.094))
    ##xbmc.log'Initial HI is %sF' % (HI),level=xbmc.LOGERROR)
    # Test if simply formula is applicable
    if HI > 80:    # then we need to use the full fancy formula
        ##xbmc.log'HI is over 80 %sF' % (HI),level=xbmc.LOGERROR)
        HI = ( -42.379 
               + 2.04901523*T 
               + 10.14333127*R 
               - .22475541*T*R 
               - .00683783*T*T 
               - .05481717*R*R 
               + .00122874*T*T*R 
               + .00085282*T*R*R 
               - .00000199*T*T*R*R
             )
        ##xbmc.log('Fancy hi 1 is %sF' % (HI),level=xbmc.LOGERROR)
        if R < 12 and T >80 and T <115:
            ADJUSTMENT = ( (13.0-R)/4.0 ) * math.sqrt( ( 17.0-math.fabs( T-95.0) ) / 17.0 )
            HI = HI - ADJUSTMENT
            ##xbmc.log('adjusted hi 2 is %sF' % (HI),level=xbmc.LOGERROR)
        if R > 85 and T >80 and T <87:
            ADJUSTMENT = ( (R-85.0)/10.0 ) * ( (87.0-T)/5.0 )
            HI = HI + ADJUSTMENT    
            ##xbmc.log('adjusted hi 3 is %sF' % (HI),level=xbmc.LOGERROR)
    ##xbmc.log'Final HI is %sF' % (HI),level=xbmc.LOGERROR)
    if HI > 80 and HI > (T+2):    # if we have a heat-index, over 80 (and it's highter then the normal temp) then return it
        ##xbmc.log'Heat Index for %sF %sH = %sF' % (T, R, HI),level=xbmc.LOGERROR)
        return HI

def HEAT_INDEX_C(Ts, Rs):
    T=float(Ts)
    R=float(Rs)
    TF = CtoF(T) # calaculation is done in F
    HI = HEAT_INDEX_F(TF, R)
    if HI: 
        return FtoC(HI)
    # otherwise, no relevennt heat index so return
        

#### thanks to FrostBox @ http://forum.kodi.tv/showthread.php?tid=114637&pid=937168#pid937168
def DEW_POINT(Tc=0.0, R=93.0, ext=True, minR=( 0, 0.075 )[ 0 ]):
    Es = 6.11 * math.pow(10.0,( 7.5 * Tc / ( 237.7 + Tc ) ))
    R = R or minR
    E = ( R * Es ) / 100.0
    try:
        DewPoint = ( -430.22 + 237.7 * math.log( E ) ) / ( -math.log( E ) + 19.08 )
    except ValueError:
        DewPoint = 0
    if ext:
        return TEMP( DewPoint )
    else:
        return str(int(round(DewPoint)))


## a couple functions from itertools
def repeat_x(object_x, times=None):
    # repeat(10, 3) --> 10 10 10
    if times is None:
        while True:
            yield object_x
    else:
        for i in range(times):
            yield object_x

def zip_x(fill, *args):
    # zip_longest('ABCD', 'xy', fillvalue='-') --> Ax By C- D-
    iterators = [iter(it) for it in args]
    num_active = len(iterators)
    if not num_active:
        return
    while True:
        values = []
        for i, it in enumerate(iterators):
            try:
                value = next(it)
            except StopIteration:
                num_active -= 1
                if not num_active:
                    return
                iterators[i] = repeat_x(fill)
                value = fill
            values.append(value)
        yield tuple(values)

def get_timestamp(datestr):
    #"2019-04-29T16:00:00-04:00"
    #iso_fmt = '%Y-%m-%dT%H:%M:%S%z'
    datestamp=parse(datestr)
    return time.mktime(datestamp.timetuple())


def convert_date(stamp):
    if str(stamp).startswith('-'):
        return ''
    date_time = time.localtime(stamp)
    if DATEFORMAT[1] == 'd' or DATEFORMAT[0] == 'D':
        localdate = time.strftime('%d-%m-%Y', date_time)
    elif DATEFORMAT[1] == 'm' or DATEFORMAT[0] == 'M':
        localdate = time.strftime('%m-%d-%Y', date_time)
    else:
        localdate = time.strftime('%Y-%m-%d', date_time)

    if TIMEFORMAT != '/':
        localtime = time.strftime('%I:%M%p', date_time)
    else:
        localtime = time.strftime('%H:%M', date_time)
    return localtime + '    ' + localdate

def get_time(stamp):
    date_time = time.localtime(stamp)
    if TIMEFORMAT != '/':
        localtime = time.strftime('%I:%M%p', date_time)
    else:
        localtime = time.strftime('%H:%M', date_time)
    return localtime

def get_weekday(stamp, form):
    date_time = time.localtime(stamp)
    weekday = time.strftime('%w', date_time)
    if form == 's':
        return xbmc.getLocalizedString(WEEK_DAY_SHORT[weekday])
    elif form == 'l':
        return xbmc.getLocalizedString(WEEK_DAY_LONG[weekday])
    else:
        return int(weekday)

#def get_month(stamp, form):
#    date_time = time.localtime(stamp)
#    month = time.strftime('%m', date_time)
#    day = time.strftime('%d', date_time)
#    weekday = time.strftime('%u', date_time)-1
#    if form == 'ds':
#        label = xbmc.getLocalizedString(MONTH_NAME_SHORT[month])
#    elif form == 'dl':
#        label = xbmc.getLocalizedString(MONTH_NAME_LONG[month])
#    elif form == 'ms':
#        label = xbmc.getLocalizedString(MONTH_NAME_SHORT[month])
#    elif form == 'ml':
#        label = xbmc.getLocalizedString(MONTH_NAME_LONG[month])
#    return label

def get_fulldatestr(stamp,form):
    date_time = time.localtime(stamp)
    month = time.strftime('%m', date_time)
    day = time.strftime('%d', date_time)
    weekday = time.strftime('%w', date_time)
    if form == 'ds':
        label = xbmc.getLocalizedString(WEEK_DAY_SHORT[weekday]) + ' ' + day + ' ' + xbmc.getLocalizedString(MONTH_NAME_SHORT[month])
    elif form == 'dl':
        label = xbmc.getLocalizedString(WEEK_DAY_LONG[weekday]) + ' ' + day + ' ' + xbmc.getLocalizedString(MONTH_NAME_LONG[month])
    elif form == 'ms':
        label = xbmc.getLocalizedString(WEEK_DAY_SHORT[weekday]) + ' ' + xbmc.getLocalizedString(MONTH_NAME_SHORT[month]) + ' ' + day
    elif form == 'ml':
        label = xbmc.getLocalizedString(WEEK_DAY_LONG[weekday]) + ' ' + xbmc.getLocalizedString(MONTH_NAME_LONG[month]) + ' ' + day
    return label

def get_datestr(stamp,form):
    date_time = time.localtime(stamp)
    month = time.strftime('%m', date_time)
    day = time.strftime('%d', date_time)
    if form == 'ds':
        label = day + ' ' + xbmc.getLocalizedString(MONTH_NAME_SHORT[month])
    elif form == 'dl':
        label = day + ' ' + xbmc.getLocalizedString(MONTH_NAME_LONG[month])
    elif form == 'ms':
        label = xbmc.getLocalizedString(MONTH_NAME_SHORT[month]) + ' ' + day
    elif form == 'ml':
        label = xbmc.getLocalizedString(MONTH_NAME_LONG[month]) + ' ' + day
    return label

# Satellite Imagery paths



MAPSECTORS = {
    "conus-e": {
        "name":LANGUAGE(32360),
        "sat":"GOES19",
        "loc":"CONUS",
        "static":"1250x750.jpg",
        "loop":"625x375.gif",
    },
    "conus-w": {
        "name":LANGUAGE(32361),
        "path":"GOES18/%s/CONUS/%s/1250x750.jpg",
        "sat":"GOES18",
        "loc":"CONUS",
        "static":"1250x750.jpg",
        "loop":"625x375.gif",
    },
    "ak": {
        "name":LANGUAGE(32364), 
        "path":"GOES18/ABI/SECTOR/ak/%s/1000x1000.jpg",
        "sat":"GOES18",
        "loc":"AK",
        "static":"1000x1000.jpg",
        "loop":"1000x1000.gif",
    },
    "cak": {
        "name":LANGUAGE(32365),
        "path":"GOES18/ABI/SECTOR/cak/%s/1200x1200.jpg",
        "sat":"GOES18",
        "loc":"CAK",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "sea": {
        "name":LANGUAGE(32366),
        "path":"GOES18/ABI/SECTOR/sea/%s/1200x1200.jpg",
        "sat":"GOES18",
        "loc":"SEA",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "np": {
        "name":LANGUAGE(32367),
         "path":"GOES18/ABI/SECTOR/np/%s/900x540.jpg",
        "sat":"GOES18",
        "loc":"NP",
        "static":"900x540.jpg",
        "loop":"900x540.gif",
        },
    "wus": {
        "name":LANGUAGE(32368),
        "path":"GOES18/ABI/SECTOR/wus/%s/1000x1000.jpg",
        "sat":"GOES18",
        "loc":"WUS",
        "static":"1000x1000.jpg",
        "loop":"1000x1000.gif",
        },
    "pnw-w": {
        "name":LANGUAGE(32369),
        "path":"GOES18/ABI/SECTOR/pnw/%s/1200x1200.jpg",
        "sat":"GOES18",
        "loc":"PNW",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "pnw-e": {
        "name":LANGUAGE(32370),
         "path":"GOES19/ABI/SECTOR/pnw/%s/1200x1200.jpg",
        "sat":"GOES19",
        "loc":"PNW",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "psw-w": {
        "name":LANGUAGE(32371),
        "path":"GOES18/ABI/SECTOR/psw/%s/1200x1200.jpg",
        "sat":"GOES18",
        "loc":"PSW",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "psw-e": {
        "name":LANGUAGE(32371),
         "path":"GOES19/ABI/SECTOR/psw/%s/1200x1200.jpg",
        "sat":"GOES19",
        "loc":"PSW",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "nr": {
        "name":LANGUAGE(32373),
        "path":"GOES19/ABI/SECTOR/nr/%s/1200x1200.jpg",
        "sat":"GOES19",
        "loc":"NR",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "sr": {
        "name":LANGUAGE(32374),
        "path":"GOES19/ABI/SECTOR/sr/%s/1200x1200.jpg",
        "sat":"GOES19",
        "loc":"SR",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "sp": {
        "name":LANGUAGE(32375),
         "path":"GOES19/ABI/SECTOR/sp/%s/1200x1200.jpg",
        "sat":"GOES19",
        "loc":"SP",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "umv": {
        "name":LANGUAGE(32376),
         "path":"GOES19/ABI/SECTOR/umv/%s/1200x1200.jpg",
        "sat":"GOES19",
        "loc":"UMV",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "smv": {
        "name":LANGUAGE(32377),
         "path":"GOES19/ABI/SECTOR/smv/%s/1200x1200.jpg",
        "sat":"GOES19",
        "loc":"SMV",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "can": {
        "name":LANGUAGE(32378),
        "path":"GOES19/ABI/SECTOR/can/%s/1125x560.jpg",
        "sat":"GOES19",
        "loc":"CAN",
        "static":"1125x560.jpg",
        "loop":"1125x560.gif",
        },
    "cgl": {
        "name":LANGUAGE(32379),
         "path":"GOES19/ABI/SECTOR/cgl/%s/1200x1200.jpg",
        "sat":"GOES19",
        "loc":"CGL",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "eus": {
        "name":LANGUAGE(32380),
         "path":"GOES19/ABI/SECTOR/eus/%s/1000x1000.jpg",
        "sat":"GOES19",
        "loc":"EUS",
        "static":"1000x1000.jpg",
        "loop":"1000x1000.gif",
        },
    "ne": {
        "name":LANGUAGE(32381),
        "path":"GOES19/ABI/SECTOR/ne/%s/1200x1200.jpg",
        "sat":"GOES19",
        "loc":"NE",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    
    "na": {
        "name":LANGUAGE(32382),
        "path":"GOES19/ABI/SECTOR/na/%s/900x540.jpg",
        "sat":"GOES19",
        "loc":"NA",
        "static":"900x540.jpg",
        "loop":"900x540.gif",
        },
    "se": {
        "name":LANGUAGE(32383),
         "path":"GOES19/ABI/SECTOR/se/%s/1200x1200.jpg",
        "sat":"GOES19",
        "loc":"SE",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "car": {
        "name":LANGUAGE(32384),
        "path":"GOES19/ABI/SECTOR/car/%s/1000x1000.jpg",
        "sat":"GOES19",
        "loc":"CAR",
        "static":"1000x1000.jpg",
        "loop":"1000x1000.gif",
        },
    "pr": {
        "name":LANGUAGE(32385),
         "path":"GOES19/ABI/SECTOR/pr/%s/1200x1200.jpg",
        "sat":"GOES19",
        "loc":"PR",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "gm": {
        "name":LANGUAGE(32386),
         "path":"GOES19/ABI/SECTOR/ga/%s/1000x1000.jpg",
        "sat":"GOES19",
        "loc":"GA",
        "static":"1000x1000.jpg",
        "loop":"1000x1000.gif",
        },
    "taw": {
        "name":LANGUAGE(32387),
        "path":"GOES19/ABI/SECTOR/taw/%s/900x540.jpg",
        "sat":"GOES19",
        "loc":"TAW",
        "static":"900x540.jpg",
        "loop":"900x540.gif",
        },
    "mex": {
        "name":LANGUAGE(32388),
         "path":"GOES19/ABI/SECTOR/mex/%s/1000x1000.jpg",
        "sat":"GOES19",
        "loc":"MEX",
        "static":"1000x1000.jpg",
        "loop":"1000x1000.gif",
        },
    "hi": {
        "name":LANGUAGE(32389),
         "path":"GOES18/ABI/SECTOR/hi/%s/1200x1200.jpg",
        "sat":"GOES18",
        "loc":"HI",
        "static":"1200x1200.jpg",
        "loop":"600x600.gif",
        },
    "tpw": {
        "name":LANGUAGE(32390),
         "path":"GOES18/ABI/SECTOR/tpw/%s/900x540.jpg",
        "sat":"GOES18",
        "loc":"TPW",
        "static":"900x540.jpg",
        "loop":"900x540.gif",
        },
    "tsp": {
        "name":LANGUAGE(32391),
         "path":"GOES18/ABI/SECTOR/tsp/%s/900x540.jpg",
        "sat":"GOES18",
        "loc":"TSP",
        "static":"900x540.jpg",
        "loop":"900x540.gif",
        },
    "eep": {
        "name":LANGUAGE(32392),
        "path":"GOES19/ABI/SECTOR/eep/%s/900x540.jpg",
        "sat":"GOES19",
        "loc":"EEP",
        "static":"900x540.jpg",
        "loop":"900x540.gif",
        },
    "cam": {
        "name":LANGUAGE(32393),
        "path":"GOES19/ABI/SECTOR/cam/%s/1000x1000.jpg",
        "sat":"GOES19",
        "loc":"CAM",
        "static":"1000x1000.jpg",
        "loop":"1000x1000.gif",
        },
    "nsa": {
        "name":LANGUAGE(32394),
        "path":"GOES19/ABI/SECTOR/nsa/%s/900x540.jpg",
        "sat":"GOES19",
        "loc":"NSA",
        "static":"900x540.jpg",
        "loop":"900x540.gif",
        },
    "ssa": {
        "name":LANGUAGE(32395),
        "path":"GOES19/ABI/SECTOR/ssa/%s/900x540.jpg",
        "sat":"GOES19",
        "loc":"SSA",
        "static":"900x540.jpg",
        "loop":"900x540.gif",
        }
    }

MAPTYPES = {
    "RADAR_LOOP": {
        "name":LANGUAGE(32333),
        "type":"RADAR",
        "subtype":"",
        "imagetype":"loop",
        },
    "GEOCOLOR": {
        "name":LANGUAGE(32400),
        "type":"ABI",
        "subtype":"GEOCOLOR",
        "imagetype":"static",
        },
    "GEOCOLOR_LOOP": {
        "name":LANGUAGE(32403),
        "type":"ABI",
        "subtype":"GEOCOLOR",
        "imagetype":"loop",
        },
    "EXTENT": {
        "name":LANGUAGE(32401),
        "type":"GLM",
        "subtype":"EXTENT3",
        "imagetype":"static",
        },
    "EXTENT_LOOP": {
        "name":LANGUAGE(32425),
        "type":"GLM",
        "subtype":"EXTENT3",
        "imagetype":"loop",
        },
    "AirMass": {
        "name":LANGUAGE(32404),
        "type":"ABI",
        "subtype":"AirMass",
        "imagetype":"static",
        },
    "AirMass_LOOP": {
        "name":LANGUAGE(32426),
        "type":"ABI",
        "subtype":"AirMass",
        "imagetype":"loop",
        },
    "DMW": {
        "name":LANGUAGE(32407),
        "type":"ABI",
        "subtype":"DMW",
        "imagetype":"static",
        },
    "DayNightCloudMicroCombo": {
        "name":LANGUAGE(32427),
        "type":"ABI",
        "subtype":"DayNightCloudMicroCombo",
        "imagetype":"static",
        },
    "DayNightCloudMicroCombo_LOOP": {
        "name":LANGUAGE(32428),
        "type":"ABI",
        "subtype":"DayNightCloudMicroCombo",
        "imagetype":"loop",
        },
    "Dust": {
        "name":LANGUAGE(32408),
        "type":"ABI",
        "subtype":"Dust",
        "imagetype":"static",
        },
    "FireTemperature": {
        "name":LANGUAGE(32405),
        "type":"ABI",
        "subtype":"FireTemperature",
        "imagetype":"static",
        },
    "FireTemperature_LOOP": {
        "name":LANGUAGE(32429),
        "type":"ABI",
        "subtype":"FireTemperature",
        "imagetype":"loop",
        },
    "Sandwich": {
        "name":LANGUAGE(32402),
        "type":"ABI",
        "subtype":"Sandwich",
        "imagetype":"static",
        },
    "Sandwich_LOOP": {
        "name":LANGUAGE(32430),
        "type":"ABI",
        "subtype":"Sandwich",
        "imagetype":"loop",
        },
    "01": {
        "name":LANGUAGE(32409),
        "type":"ABI",
        "subtype":"01",
        "imagetype":"static",
        },
    "02": {
        "name":LANGUAGE(32410),
        "type":"ABI",
        "subtype":"02",
        "imagetype":"static",
        },
    "03": {
        "name": LANGUAGE(32411),
        "type":"ABI",
        "subtype":"03",
        "imagetype":"static",
        },
    "04": {
        "name": LANGUAGE(32412),
        "type":"ABI",
        "subtype":"04",
        "imagetype":"static",
        },
    "05": {
        "name": LANGUAGE(32413),
        "type":"ABI",
        "subtype":"05",
        "imagetype":"static",
        },
    "06": {
        "name": LANGUAGE(32414),
        "type":"ABI",
        "subtype":"06",
        "imagetype":"static",
        },
    "07": {
        "name": LANGUAGE(32415),
        "type":"ABI",
        "subtype":"07",
        "imagetype":"static",
        },
    "08": {
        "name": LANGUAGE(32416),
        "type":"ABI",
        "subtype":"08",
        "imagetype":"static",
        },
    "09": {
        "name": LANGUAGE(32417),
        "type":"ABI",
        "subtype":"09",
        "imagetype":"static",
        },
    "10": {
        "name": LANGUAGE(32418),
        "type":"ABI",
        "subtype":"10",
        "imagetype":"static",
        },
    "11": {
        "name": LANGUAGE(32419),
        "type":"ABI",
        "subtype":"11",
        "imagetype":"static",
        },
    "12": {
        "name": LANGUAGE(32420),
        "type":"ABI",
        "subtype":"12",
        "imagetype":"static",
        },
    "13": {
        "name": LANGUAGE(32421),
        "type":"ABI",
        "subtype":"13",
        "imagetype":"static",
        },
    "14": {
        "name": LANGUAGE(32422),
        "type":"ABI",
        "subtype":"14",
        "imagetype":"static",
        },
    "15": {
        "name": LANGUAGE(32423),
        "type":"ABI",
        "subtype":"15",
        "imagetype":"static",
        },
    "16": {
        "name": LANGUAGE(32424),
        "type":"ABI",
        "subtype":"16",
        "imagetype":"static",
        },
    }

LOOPSECTORS = {
    ##ridge/standard/CONUS_loop.gif
    "us":    {"name":LANGUAGE(32396),"path":"ridge/standard/CONUS-LARGE_loop.gif"},
    "pnw":   {"name":LANGUAGE(32369),"path":"ridge/standard/PACNORTHWEST_loop.gif"},
    "psw":   {"name":LANGUAGE(32371),"path":"ridge/standard/PACSOUTHWEST_loop.gif"},
    "nr":    {"name":LANGUAGE(32373),"path":"ridge/standard/NORTHROCKIES_loop.gif"},
    "sr":    {"name":LANGUAGE(32374),"path":"ridge/standard/SOUTHROCKIES_loop.gif"},
    "sp":    {"name":LANGUAGE(32375),"path":"ridge/standard/SOUTHPLAINS_loop.gif"},
    "umv":   {"name":LANGUAGE(32376),"path":"ridge/standard/UPPERMISSVLY_loop.gif"},
    "smv":   {"name":LANGUAGE(32377),"path":"ridge/standard/SOUTHMISSVLY_loop.gif"},
    "cgl":   {"name":LANGUAGE(32379),"path":"ridge/standard/CENTGRLAKES_loop.gif"},
    "ne":    {"name":LANGUAGE(32381),"path":"ridge/standard/NORTHEAST_loop.gif"},
    "se":    {"name":LANGUAGE(32383),"path":"ridge/standard/SOUTHEAST_loop.gif"},
    "car":   {"name":LANGUAGE(32384),"path":"ridge/standard/CARIB_loop.gif"},
    "ak":    {"name":LANGUAGE(32364),"path":"ridge/standard/ALASKA_loop.gif"},
    "hi":    {"name":LANGUAGE(32389),"path":"ridge/standard/HAWAII_loop.gif"},
    "guam":  {"name":LANGUAGE(32397),"path":"ridge/standard/GUAM_loop.gif"}
    }

